/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An instance type that the specified Amazon EMR release supports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedInstanceType implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedInstanceType.Builder, SupportedInstanceType> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SupportedInstanceType::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> MEMORY_GB_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("MemoryGB")
            .getter(getter(SupportedInstanceType::memoryGB)).setter(setter(Builder::memoryGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryGB").build()).build();

    private static final SdkField<Integer> STORAGE_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageGB").getter(getter(SupportedInstanceType::storageGB)).setter(setter(Builder::storageGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageGB").build()).build();

    private static final SdkField<Integer> VCPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("VCPU")
            .getter(getter(SupportedInstanceType::vcpu)).setter(setter(Builder::vcpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCPU").build()).build();

    private static final SdkField<Boolean> IS64_BITS_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Is64BitsOnly").getter(getter(SupportedInstanceType::is64BitsOnly)).setter(setter(Builder::is64BitsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Is64BitsOnly").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamilyId").getter(getter(SupportedInstanceType::instanceFamilyId))
            .setter(setter(Builder::instanceFamilyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamilyId").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_AVAILABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimizedAvailable").getter(getter(SupportedInstanceType::ebsOptimizedAvailable))
            .setter(setter(Builder::ebsOptimizedAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedAvailable").build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_BY_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimizedByDefault").getter(getter(SupportedInstanceType::ebsOptimizedByDefault))
            .setter(setter(Builder::ebsOptimizedByDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedByDefault").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_DISKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDisks").getter(getter(SupportedInstanceType::numberOfDisks))
            .setter(setter(Builder::numberOfDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDisks").build()).build();

    private static final SdkField<Boolean> EBS_STORAGE_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsStorageOnly").getter(getter(SupportedInstanceType::ebsStorageOnly))
            .setter(setter(Builder::ebsStorageOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsStorageOnly").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(SupportedInstanceType::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MEMORY_GB_FIELD,
            STORAGE_GB_FIELD, VCPU_FIELD, IS64_BITS_ONLY_FIELD, INSTANCE_FAMILY_ID_FIELD, EBS_OPTIMIZED_AVAILABLE_FIELD,
            EBS_OPTIMIZED_BY_DEFAULT_FIELD, NUMBER_OF_DISKS_FIELD, EBS_STORAGE_ONLY_FIELD, ARCHITECTURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float memoryGB;

    private final Integer storageGB;

    private final Integer vcpu;

    private final Boolean is64BitsOnly;

    private final String instanceFamilyId;

    private final Boolean ebsOptimizedAvailable;

    private final Boolean ebsOptimizedByDefault;

    private final Integer numberOfDisks;

    private final Boolean ebsStorageOnly;

    private final String architecture;

    private SupportedInstanceType(BuilderImpl builder) {
        this.type = builder.type;
        this.memoryGB = builder.memoryGB;
        this.storageGB = builder.storageGB;
        this.vcpu = builder.vcpu;
        this.is64BitsOnly = builder.is64BitsOnly;
        this.instanceFamilyId = builder.instanceFamilyId;
        this.ebsOptimizedAvailable = builder.ebsOptimizedAvailable;
        this.ebsOptimizedByDefault = builder.ebsOptimizedByDefault;
        this.numberOfDisks = builder.numberOfDisks;
        this.ebsStorageOnly = builder.ebsStorageOnly;
        this.architecture = builder.architecture;
    }

    /**
     * <p>
     * The <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 instance type</a>, for example
     * <code>m5.xlarge</code>, of the <code>SupportedInstanceType</code>.
     * </p>
     * 
     * @return The <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 instance type</a>, for example
     *         <code>m5.xlarge</code>, of the <code>SupportedInstanceType</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The amount of memory that is available to Amazon EMR from the <code>SupportedInstanceType</code>. The kernel and
     * hypervisor software consume some memory, so this value might be lower than the overall memory for the instance
     * type.
     * </p>
     * 
     * @return The amount of memory that is available to Amazon EMR from the <code>SupportedInstanceType</code>. The
     *         kernel and hypervisor software consume some memory, so this value might be lower than the overall memory
     *         for the instance type.
     */
    public final Float memoryGB() {
        return memoryGB;
    }

    /**
     * <p>
     * <code>StorageGB</code> represents the storage capacity of the <code>SupportedInstanceType</code>. This value is
     * <code>0</code> for Amazon EBS-only instance types.
     * </p>
     * 
     * @return <code>StorageGB</code> represents the storage capacity of the <code>SupportedInstanceType</code>. This
     *         value is <code>0</code> for Amazon EBS-only instance types.
     */
    public final Integer storageGB() {
        return storageGB;
    }

    /**
     * <p>
     * The number of vCPUs available for the <code>SupportedInstanceType</code>.
     * </p>
     * 
     * @return The number of vCPUs available for the <code>SupportedInstanceType</code>.
     */
    public final Integer vcpu() {
        return vcpu;
    }

    /**
     * <p>
     * Indicates whether the <code>SupportedInstanceType</code> only supports 64-bit architecture.
     * </p>
     * 
     * @return Indicates whether the <code>SupportedInstanceType</code> only supports 64-bit architecture.
     */
    public final Boolean is64BitsOnly() {
        return is64BitsOnly;
    }

    /**
     * <p>
     * The Amazon EC2 family and generation for the <code>SupportedInstanceType</code>.
     * </p>
     * 
     * @return The Amazon EC2 family and generation for the <code>SupportedInstanceType</code>.
     */
    public final String instanceFamilyId() {
        return instanceFamilyId;
    }

    /**
     * <p>
     * Indicates whether the <code>SupportedInstanceType</code> supports Amazon EBS optimization.
     * </p>
     * 
     * @return Indicates whether the <code>SupportedInstanceType</code> supports Amazon EBS optimization.
     */
    public final Boolean ebsOptimizedAvailable() {
        return ebsOptimizedAvailable;
    }

    /**
     * <p>
     * Indicates whether the <code>SupportedInstanceType</code> uses Amazon EBS optimization by default.
     * </p>
     * 
     * @return Indicates whether the <code>SupportedInstanceType</code> uses Amazon EBS optimization by default.
     */
    public final Boolean ebsOptimizedByDefault() {
        return ebsOptimizedByDefault;
    }

    /**
     * <p>
     * Number of disks for the <code>SupportedInstanceType</code>. This value is <code>0</code> for Amazon EBS-only
     * instance types.
     * </p>
     * 
     * @return Number of disks for the <code>SupportedInstanceType</code>. This value is <code>0</code> for Amazon
     *         EBS-only instance types.
     */
    public final Integer numberOfDisks() {
        return numberOfDisks;
    }

    /**
     * <p>
     * Indicates whether the <code>SupportedInstanceType</code> only supports Amazon EBS.
     * </p>
     * 
     * @return Indicates whether the <code>SupportedInstanceType</code> only supports Amazon EBS.
     */
    public final Boolean ebsStorageOnly() {
        return ebsStorageOnly;
    }

    /**
     * <p>
     * The CPU architecture, for example <code>X86_64</code> or <code>AARCH64</code>.
     * </p>
     * 
     * @return The CPU architecture, for example <code>X86_64</code> or <code>AARCH64</code>.
     */
    public final String architecture() {
        return architecture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(memoryGB());
        hashCode = 31 * hashCode + Objects.hashCode(storageGB());
        hashCode = 31 * hashCode + Objects.hashCode(vcpu());
        hashCode = 31 * hashCode + Objects.hashCode(is64BitsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamilyId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimizedAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimizedByDefault());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(ebsStorageOnly());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedInstanceType)) {
            return false;
        }
        SupportedInstanceType other = (SupportedInstanceType) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(memoryGB(), other.memoryGB())
                && Objects.equals(storageGB(), other.storageGB()) && Objects.equals(vcpu(), other.vcpu())
                && Objects.equals(is64BitsOnly(), other.is64BitsOnly())
                && Objects.equals(instanceFamilyId(), other.instanceFamilyId())
                && Objects.equals(ebsOptimizedAvailable(), other.ebsOptimizedAvailable())
                && Objects.equals(ebsOptimizedByDefault(), other.ebsOptimizedByDefault())
                && Objects.equals(numberOfDisks(), other.numberOfDisks())
                && Objects.equals(ebsStorageOnly(), other.ebsStorageOnly())
                && Objects.equals(architecture(), other.architecture());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedInstanceType").add("Type", type()).add("MemoryGB", memoryGB())
                .add("StorageGB", storageGB()).add("VCPU", vcpu()).add("Is64BitsOnly", is64BitsOnly())
                .add("InstanceFamilyId", instanceFamilyId()).add("EbsOptimizedAvailable", ebsOptimizedAvailable())
                .add("EbsOptimizedByDefault", ebsOptimizedByDefault()).add("NumberOfDisks", numberOfDisks())
                .add("EbsStorageOnly", ebsStorageOnly()).add("Architecture", architecture()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "MemoryGB":
            return Optional.ofNullable(clazz.cast(memoryGB()));
        case "StorageGB":
            return Optional.ofNullable(clazz.cast(storageGB()));
        case "VCPU":
            return Optional.ofNullable(clazz.cast(vcpu()));
        case "Is64BitsOnly":
            return Optional.ofNullable(clazz.cast(is64BitsOnly()));
        case "InstanceFamilyId":
            return Optional.ofNullable(clazz.cast(instanceFamilyId()));
        case "EbsOptimizedAvailable":
            return Optional.ofNullable(clazz.cast(ebsOptimizedAvailable()));
        case "EbsOptimizedByDefault":
            return Optional.ofNullable(clazz.cast(ebsOptimizedByDefault()));
        case "NumberOfDisks":
            return Optional.ofNullable(clazz.cast(numberOfDisks()));
        case "EbsStorageOnly":
            return Optional.ofNullable(clazz.cast(ebsStorageOnly()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("MemoryGB", MEMORY_GB_FIELD);
        map.put("StorageGB", STORAGE_GB_FIELD);
        map.put("VCPU", VCPU_FIELD);
        map.put("Is64BitsOnly", IS64_BITS_ONLY_FIELD);
        map.put("InstanceFamilyId", INSTANCE_FAMILY_ID_FIELD);
        map.put("EbsOptimizedAvailable", EBS_OPTIMIZED_AVAILABLE_FIELD);
        map.put("EbsOptimizedByDefault", EBS_OPTIMIZED_BY_DEFAULT_FIELD);
        map.put("NumberOfDisks", NUMBER_OF_DISKS_FIELD);
        map.put("EbsStorageOnly", EBS_STORAGE_ONLY_FIELD);
        map.put("Architecture", ARCHITECTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedInstanceType, T> g) {
        return obj -> g.apply((SupportedInstanceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedInstanceType> {
        /**
         * <p>
         * The <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 instance type</a>, for example
         * <code>m5.xlarge</code>, of the <code>SupportedInstanceType</code>.
         * </p>
         * 
         * @param type
         *        The <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 instance type</a>, for example
         *        <code>m5.xlarge</code>, of the <code>SupportedInstanceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The amount of memory that is available to Amazon EMR from the <code>SupportedInstanceType</code>. The kernel
         * and hypervisor software consume some memory, so this value might be lower than the overall memory for the
         * instance type.
         * </p>
         * 
         * @param memoryGB
         *        The amount of memory that is available to Amazon EMR from the <code>SupportedInstanceType</code>. The
         *        kernel and hypervisor software consume some memory, so this value might be lower than the overall
         *        memory for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryGB(Float memoryGB);

        /**
         * <p>
         * <code>StorageGB</code> represents the storage capacity of the <code>SupportedInstanceType</code>. This value
         * is <code>0</code> for Amazon EBS-only instance types.
         * </p>
         * 
         * @param storageGB
         *        <code>StorageGB</code> represents the storage capacity of the <code>SupportedInstanceType</code>. This
         *        value is <code>0</code> for Amazon EBS-only instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageGB(Integer storageGB);

        /**
         * <p>
         * The number of vCPUs available for the <code>SupportedInstanceType</code>.
         * </p>
         * 
         * @param vcpu
         *        The number of vCPUs available for the <code>SupportedInstanceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcpu(Integer vcpu);

        /**
         * <p>
         * Indicates whether the <code>SupportedInstanceType</code> only supports 64-bit architecture.
         * </p>
         * 
         * @param is64BitsOnly
         *        Indicates whether the <code>SupportedInstanceType</code> only supports 64-bit architecture.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder is64BitsOnly(Boolean is64BitsOnly);

        /**
         * <p>
         * The Amazon EC2 family and generation for the <code>SupportedInstanceType</code>.
         * </p>
         * 
         * @param instanceFamilyId
         *        The Amazon EC2 family and generation for the <code>SupportedInstanceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamilyId(String instanceFamilyId);

        /**
         * <p>
         * Indicates whether the <code>SupportedInstanceType</code> supports Amazon EBS optimization.
         * </p>
         * 
         * @param ebsOptimizedAvailable
         *        Indicates whether the <code>SupportedInstanceType</code> supports Amazon EBS optimization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimizedAvailable(Boolean ebsOptimizedAvailable);

        /**
         * <p>
         * Indicates whether the <code>SupportedInstanceType</code> uses Amazon EBS optimization by default.
         * </p>
         * 
         * @param ebsOptimizedByDefault
         *        Indicates whether the <code>SupportedInstanceType</code> uses Amazon EBS optimization by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimizedByDefault(Boolean ebsOptimizedByDefault);

        /**
         * <p>
         * Number of disks for the <code>SupportedInstanceType</code>. This value is <code>0</code> for Amazon EBS-only
         * instance types.
         * </p>
         * 
         * @param numberOfDisks
         *        Number of disks for the <code>SupportedInstanceType</code>. This value is <code>0</code> for Amazon
         *        EBS-only instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDisks(Integer numberOfDisks);

        /**
         * <p>
         * Indicates whether the <code>SupportedInstanceType</code> only supports Amazon EBS.
         * </p>
         * 
         * @param ebsStorageOnly
         *        Indicates whether the <code>SupportedInstanceType</code> only supports Amazon EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsStorageOnly(Boolean ebsStorageOnly);

        /**
         * <p>
         * The CPU architecture, for example <code>X86_64</code> or <code>AARCH64</code>.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture, for example <code>X86_64</code> or <code>AARCH64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float memoryGB;

        private Integer storageGB;

        private Integer vcpu;

        private Boolean is64BitsOnly;

        private String instanceFamilyId;

        private Boolean ebsOptimizedAvailable;

        private Boolean ebsOptimizedByDefault;

        private Integer numberOfDisks;

        private Boolean ebsStorageOnly;

        private String architecture;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedInstanceType model) {
            type(model.type);
            memoryGB(model.memoryGB);
            storageGB(model.storageGB);
            vcpu(model.vcpu);
            is64BitsOnly(model.is64BitsOnly);
            instanceFamilyId(model.instanceFamilyId);
            ebsOptimizedAvailable(model.ebsOptimizedAvailable);
            ebsOptimizedByDefault(model.ebsOptimizedByDefault);
            numberOfDisks(model.numberOfDisks);
            ebsStorageOnly(model.ebsStorageOnly);
            architecture(model.architecture);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Float getMemoryGB() {
            return memoryGB;
        }

        public final void setMemoryGB(Float memoryGB) {
            this.memoryGB = memoryGB;
        }

        @Override
        public final Builder memoryGB(Float memoryGB) {
            this.memoryGB = memoryGB;
            return this;
        }

        public final Integer getStorageGB() {
            return storageGB;
        }

        public final void setStorageGB(Integer storageGB) {
            this.storageGB = storageGB;
        }

        @Override
        public final Builder storageGB(Integer storageGB) {
            this.storageGB = storageGB;
            return this;
        }

        public final Integer getVcpu() {
            return vcpu;
        }

        public final void setVcpu(Integer vcpu) {
            this.vcpu = vcpu;
        }

        @Override
        public final Builder vcpu(Integer vcpu) {
            this.vcpu = vcpu;
            return this;
        }

        public final Boolean getIs64BitsOnly() {
            return is64BitsOnly;
        }

        public final void setIs64BitsOnly(Boolean is64BitsOnly) {
            this.is64BitsOnly = is64BitsOnly;
        }

        @Override
        public final Builder is64BitsOnly(Boolean is64BitsOnly) {
            this.is64BitsOnly = is64BitsOnly;
            return this;
        }

        public final String getInstanceFamilyId() {
            return instanceFamilyId;
        }

        public final void setInstanceFamilyId(String instanceFamilyId) {
            this.instanceFamilyId = instanceFamilyId;
        }

        @Override
        public final Builder instanceFamilyId(String instanceFamilyId) {
            this.instanceFamilyId = instanceFamilyId;
            return this;
        }

        public final Boolean getEbsOptimizedAvailable() {
            return ebsOptimizedAvailable;
        }

        public final void setEbsOptimizedAvailable(Boolean ebsOptimizedAvailable) {
            this.ebsOptimizedAvailable = ebsOptimizedAvailable;
        }

        @Override
        public final Builder ebsOptimizedAvailable(Boolean ebsOptimizedAvailable) {
            this.ebsOptimizedAvailable = ebsOptimizedAvailable;
            return this;
        }

        public final Boolean getEbsOptimizedByDefault() {
            return ebsOptimizedByDefault;
        }

        public final void setEbsOptimizedByDefault(Boolean ebsOptimizedByDefault) {
            this.ebsOptimizedByDefault = ebsOptimizedByDefault;
        }

        @Override
        public final Builder ebsOptimizedByDefault(Boolean ebsOptimizedByDefault) {
            this.ebsOptimizedByDefault = ebsOptimizedByDefault;
            return this;
        }

        public final Integer getNumberOfDisks() {
            return numberOfDisks;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final Boolean getEbsStorageOnly() {
            return ebsStorageOnly;
        }

        public final void setEbsStorageOnly(Boolean ebsStorageOnly) {
            this.ebsStorageOnly = ebsStorageOnly;
        }

        @Override
        public final Builder ebsStorageOnly(Boolean ebsStorageOnly) {
            this.ebsStorageOnly = ebsStorageOnly;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public SupportedInstanceType build() {
            return new SupportedInstanceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
