/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration specification to be used to override existing configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationOverrides.Builder, ConfigurationOverrides> {
    private static final SdkField<List<Configuration>> APPLICATION_CONFIGURATION_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("applicationConfiguration")
            .getter(getter(ConfigurationOverrides::applicationConfiguration))
            .setter(setter(Builder::applicationConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("monitoringConfiguration")
            .getter(getter(ConfigurationOverrides::monitoringConfiguration)).setter(setter(Builder::monitoringConfiguration))
            .constructor(MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Configuration> applicationConfiguration;

    private final MonitoringConfiguration monitoringConfiguration;

    private ConfigurationOverrides(BuilderImpl builder) {
        this.applicationConfiguration = builder.applicationConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
    }

    /**
     * Returns true if the ApplicationConfiguration property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasApplicationConfiguration() {
        return applicationConfiguration != null && !(applicationConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations for the application running by the job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplicationConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configurations for the application running by the job run.
     */
    public List<Configuration> applicationConfiguration() {
        return applicationConfiguration;
    }

    /**
     * <p>
     * The configurations for monitoring.
     * </p>
     * 
     * @return The configurations for monitoring.
     */
    public MonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationConfiguration() ? applicationConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOverrides)) {
            return false;
        }
        ConfigurationOverrides other = (ConfigurationOverrides) obj;
        return hasApplicationConfiguration() == other.hasApplicationConfiguration()
                && Objects.equals(applicationConfiguration(), other.applicationConfiguration())
                && Objects.equals(monitoringConfiguration(), other.monitoringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigurationOverrides")
                .add("ApplicationConfiguration", hasApplicationConfiguration() ? applicationConfiguration() : null)
                .add("MonitoringConfiguration", monitoringConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationConfiguration":
            return Optional.ofNullable(clazz.cast(applicationConfiguration()));
        case "monitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationOverrides, T> g) {
        return obj -> g.apply((ConfigurationOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationOverrides> {
        /**
         * <p>
         * The configurations for the application running by the job run.
         * </p>
         * 
         * @param applicationConfiguration
         *        The configurations for the application running by the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfiguration(Collection<Configuration> applicationConfiguration);

        /**
         * <p>
         * The configurations for the application running by the job run.
         * </p>
         * 
         * @param applicationConfiguration
         *        The configurations for the application running by the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfiguration(Configuration... applicationConfiguration);

        /**
         * <p>
         * The configurations for the application running by the job run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Configuration>.Builder} avoiding the need
         * to create one manually via {@link List<Configuration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Configuration>.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationConfiguration(List<Configuration>)}.
         * 
         * @param applicationConfiguration
         *        a consumer that will call methods on {@link List<Configuration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfiguration(List<Configuration>)
         */
        Builder applicationConfiguration(Consumer<Configuration.Builder>... applicationConfiguration);

        /**
         * <p>
         * The configurations for monitoring.
         * </p>
         * 
         * @param monitoringConfiguration
         *        The configurations for monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * The configurations for monitoring.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringConfiguration.Builder} avoiding the
         * need to create one manually via {@link MonitoringConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringConfiguration(MonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(MonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(MonitoringConfiguration.builder().applyMutation(monitoringConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Configuration> applicationConfiguration = DefaultSdkAutoConstructList.getInstance();

        private MonitoringConfiguration monitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOverrides model) {
            applicationConfiguration(model.applicationConfiguration);
            monitoringConfiguration(model.monitoringConfiguration);
        }

        public final Collection<Configuration.Builder> getApplicationConfiguration() {
            if (applicationConfiguration instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationConfiguration != null ? applicationConfiguration.stream().map(Configuration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationConfiguration(Collection<Configuration> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copy(applicationConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Configuration... applicationConfiguration) {
            applicationConfiguration(Arrays.asList(applicationConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Consumer<Configuration.Builder>... applicationConfiguration) {
            applicationConfiguration(Stream.of(applicationConfiguration)
                    .map(c -> Configuration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationConfiguration(Collection<Configuration.BuilderImpl> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copyFromBuilder(applicationConfiguration);
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public ConfigurationOverrides build() {
            return new ConfigurationOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
