/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedEndpointsRequest extends EmrContainersRequest implements
        ToCopyableBuilder<ListManagedEndpointsRequest.Builder, ListManagedEndpointsRequest> {
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterId").getter(getter(ListManagedEndpointsRequest::virtualClusterId))
            .setter(setter(Builder::virtualClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdBefore").getter(getter(ListManagedEndpointsRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAfter").getter(getter(ListManagedEndpointsRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(ListManagedEndpointsRequest::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(ListManagedEndpointsRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListManagedEndpointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListManagedEndpointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_CLUSTER_ID_FIELD,
            CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, TYPES_FIELD, STATES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String virtualClusterId;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private final List<String> types;

    private final List<String> states;

    private final Integer maxResults;

    private final String nextToken;

    private ListManagedEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.virtualClusterId = builder.virtualClusterId;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.types = builder.types;
        this.states = builder.states;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the virtual cluster.
     * </p>
     * 
     * @return The ID of the virtual cluster.
     */
    public String virtualClusterId() {
        return virtualClusterId;
    }

    /**
     * <p>
     * The date and time before which the endpoints are created.
     * </p>
     * 
     * @return The date and time before which the endpoints are created.
     */
    public Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The date and time after which the endpoints are created.
     * </p>
     * 
     * @return The date and time after which the endpoints are created.
     */
    public Instant createdAfter() {
        return createdAfter;
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of the managed endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types of the managed endpoints.
     */
    public List<String> types() {
        return types;
    }

    /**
     * <p>
     * The states of the managed endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The states of the managed endpoints.
     */
    public List<EndpointState> states() {
        return EndpointStatesCopier.copyStringToEnum(states);
    }

    /**
     * Returns true if the States property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states of the managed endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The states of the managed endpoints.
     */
    public List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The maximum number of managed endpoints that can be listed.
     * </p>
     * 
     * @return The maximum number of managed endpoints that can be listed.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of managed endpoints to return.
     * </p>
     * 
     * @return The token for the next set of managed endpoints to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedEndpointsRequest)) {
            return false;
        }
        ListManagedEndpointsRequest other = (ListManagedEndpointsRequest) obj;
        return Objects.equals(virtualClusterId(), other.virtualClusterId())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter())
                && hasTypes() == other.hasTypes() && Objects.equals(types(), other.types()) && hasStates() == other.hasStates()
                && Objects.equals(statesAsStrings(), other.statesAsStrings()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListManagedEndpointsRequest").add("VirtualClusterId", virtualClusterId())
                .add("CreatedBefore", createdBefore()).add("CreatedAfter", createdAfter())
                .add("Types", hasTypes() ? types() : null).add("States", hasStates() ? statesAsStrings() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualClusterId":
            return Optional.ofNullable(clazz.cast(virtualClusterId()));
        case "createdBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "createdAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedEndpointsRequest, T> g) {
        return obj -> g.apply((ListManagedEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListManagedEndpointsRequest> {
        /**
         * <p>
         * The ID of the virtual cluster.
         * </p>
         * 
         * @param virtualClusterId
         *        The ID of the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterId(String virtualClusterId);

        /**
         * <p>
         * The date and time before which the endpoints are created.
         * </p>
         * 
         * @param createdBefore
         *        The date and time before which the endpoints are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The date and time after which the endpoints are created.
         * </p>
         * 
         * @param createdAfter
         *        The date and time after which the endpoints are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The types of the managed endpoints.
         * </p>
         * 
         * @param types
         *        The types of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * The types of the managed endpoints.
         * </p>
         * 
         * @param types
         *        The types of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * The states of the managed endpoints.
         * </p>
         * 
         * @param states
         *        The states of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The states of the managed endpoints.
         * </p>
         * 
         * @param states
         *        The states of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The states of the managed endpoints.
         * </p>
         * 
         * @param states
         *        The states of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<EndpointState> states);

        /**
         * <p>
         * The states of the managed endpoints.
         * </p>
         * 
         * @param states
         *        The states of the managed endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(EndpointState... states);

        /**
         * <p>
         * The maximum number of managed endpoints that can be listed.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of managed endpoints that can be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of managed endpoints to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of managed endpoints to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String virtualClusterId;

        private Instant createdBefore;

        private Instant createdAfter;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedEndpointsRequest model) {
            super(model);
            virtualClusterId(model.virtualClusterId);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
            types(model.types);
            statesWithStrings(model.states);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getVirtualClusterId() {
            return virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = EndpointTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = EndpointTypesCopier.copy(types);
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = EndpointStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<EndpointState> states) {
            this.states = EndpointStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(EndpointState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = EndpointStatesCopier.copy(states);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedEndpointsRequest build() {
            return new ListManagedEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
