/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartJobRunRequest extends EmrContainersRequest implements
        ToCopyableBuilder<StartJobRunRequest.Builder, StartJobRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartJobRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterId").getter(getter(StartJobRunRequest::virtualClusterId))
            .setter(setter(Builder::virtualClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartJobRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(StartJobRunRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(StartJobRunRequest::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.<JobDriver> builder(MarshallingType.SDK_POJO)
            .memberName("jobDriver").getter(getter(StartJobRunRequest::jobDriver)).setter(setter(Builder::jobDriver))
            .constructor(JobDriver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()).build();

    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField
            .<ConfigurationOverrides> builder(MarshallingType.SDK_POJO).memberName("configurationOverrides")
            .getter(getter(StartJobRunRequest::configurationOverrides)).setter(setter(Builder::configurationOverrides))
            .constructor(ConfigurationOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartJobRunRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VIRTUAL_CLUSTER_ID_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, RELEASE_LABEL_FIELD, JOB_DRIVER_FIELD,
            CONFIGURATION_OVERRIDES_FIELD, TAGS_FIELD));

    private final String name;

    private final String virtualClusterId;

    private final String clientToken;

    private final String executionRoleArn;

    private final String releaseLabel;

    private final JobDriver jobDriver;

    private final ConfigurationOverrides configurationOverrides;

    private final Map<String, String> tags;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.virtualClusterId = builder.virtualClusterId;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.jobDriver = builder.jobDriver;
        this.configurationOverrides = builder.configurationOverrides;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the job run.
     * </p>
     * 
     * @return The name of the job run.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The virtual cluster ID for which the job run request is submitted.
     * </p>
     * 
     * @return The virtual cluster ID for which the job run request is submitted.
     */
    public String virtualClusterId() {
        return virtualClusterId;
    }

    /**
     * <p>
     * The client idempotency token of the job run request.
     * </p>
     * 
     * @return The client idempotency token of the job run request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The execution role ARN for the job run.
     * </p>
     * 
     * @return The execution role ARN for the job run.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Amazon EMR release version to use for the job run.
     * </p>
     * 
     * @return The Amazon EMR release version to use for the job run.
     */
    public String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The job driver for the job run.
     * </p>
     * 
     * @return The job driver for the job run.
     */
    public JobDriver jobDriver() {
        return jobDriver;
    }

    /**
     * <p>
     * The configuration overrides for the job run.
     * </p>
     * 
     * @return The configuration overrides for the job run.
     */
    public ConfigurationOverrides configurationOverrides() {
        return configurationOverrides;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to job runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to job runs.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(virtualClusterId(), other.virtualClusterId())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(jobDriver(), other.jobDriver())
                && Objects.equals(configurationOverrides(), other.configurationOverrides()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartJobRunRequest").add("Name", name()).add("VirtualClusterId", virtualClusterId())
                .add("ClientToken", clientToken()).add("ExecutionRoleArn", executionRoleArn())
                .add("ReleaseLabel", releaseLabel()).add("JobDriver", jobDriver())
                .add("ConfigurationOverrides", configurationOverrides()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "virtualClusterId":
            return Optional.ofNullable(clazz.cast(virtualClusterId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "jobDriver":
            return Optional.ofNullable(clazz.cast(jobDriver()));
        case "configurationOverrides":
            return Optional.ofNullable(clazz.cast(configurationOverrides()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartJobRunRequest, T> g) {
        return obj -> g.apply((StartJobRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartJobRunRequest> {
        /**
         * <p>
         * The name of the job run.
         * </p>
         * 
         * @param name
         *        The name of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The virtual cluster ID for which the job run request is submitted.
         * </p>
         * 
         * @param virtualClusterId
         *        The virtual cluster ID for which the job run request is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterId(String virtualClusterId);

        /**
         * <p>
         * The client idempotency token of the job run request.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token of the job run request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The execution role ARN for the job run.
         * </p>
         * 
         * @param executionRoleArn
         *        The execution role ARN for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon EMR release version to use for the job run.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release version to use for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The job driver for the job run.
         * </p>
         * 
         * @param jobDriver
         *        The job driver for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDriver(JobDriver jobDriver);

        /**
         * <p>
         * The job driver for the job run.
         * </p>
         * This is a convenience that creates an instance of the {@link JobDriver.Builder} avoiding the need to create
         * one manually via {@link JobDriver#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobDriver.Builder#build()} is called immediately and its result
         * is passed to {@link #jobDriver(JobDriver)}.
         * 
         * @param jobDriver
         *        a consumer that will call methods on {@link JobDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDriver(JobDriver)
         */
        default Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return jobDriver(JobDriver.builder().applyMutation(jobDriver).build());
        }

        /**
         * <p>
         * The configuration overrides for the job run.
         * </p>
         * 
         * @param configurationOverrides
         *        The configuration overrides for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationOverrides(ConfigurationOverrides configurationOverrides);

        /**
         * <p>
         * The configuration overrides for the job run.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationOverrides.Builder} avoiding the
         * need to create one manually via {@link ConfigurationOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationOverrides.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationOverrides(ConfigurationOverrides)}.
         * 
         * @param configurationOverrides
         *        a consumer that will call methods on {@link ConfigurationOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationOverrides(ConfigurationOverrides)
         */
        default Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return configurationOverrides(ConfigurationOverrides.builder().applyMutation(configurationOverrides).build());
        }

        /**
         * <p>
         * The tags assigned to job runs.
         * </p>
         * 
         * @param tags
         *        The tags assigned to job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String name;

        private String virtualClusterId;

        private String clientToken;

        private String executionRoleArn;

        private String releaseLabel;

        private JobDriver jobDriver;

        private ConfigurationOverrides configurationOverrides;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            name(model.name);
            virtualClusterId(model.virtualClusterId);
            clientToken(model.clientToken);
            executionRoleArn(model.executionRoleArn);
            releaseLabel(model.releaseLabel);
            jobDriver(model.jobDriver);
            configurationOverrides(model.configurationOverrides);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVirtualClusterId() {
            return virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final JobDriver.Builder getJobDriver() {
            return jobDriver != null ? jobDriver.toBuilder() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return configurationOverrides != null ? configurationOverrides.toBuilder() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
