/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrcontainers.model.ContainerProviderType;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.services.emrcontainers.model.VirtualClusterState;
import software.amazon.awssdk.services.emrcontainers.model.VirtualClusterStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualClustersRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, ListVirtualClustersRequest> {
    private static final SdkField<String> CONTAINER_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerProviderId").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::containerProviderId)).setter(ListVirtualClustersRequest.setter(Builder::containerProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("containerProviderId").build()}).build();
    private static final SdkField<String> CONTAINER_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerProviderType").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::containerProviderTypeAsString)).setter(ListVirtualClustersRequest.setter(Builder::containerProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("containerProviderType").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::createdAfter)).setter(ListVirtualClustersRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::createdBefore)).setter(ListVirtualClustersRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::statesAsStrings)).setter(ListVirtualClustersRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::maxResults)).setter(ListVirtualClustersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVirtualClustersRequest.getter(ListVirtualClustersRequest::nextToken)).setter(ListVirtualClustersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PROVIDER_ID_FIELD, CONTAINER_PROVIDER_TYPE_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, STATES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String containerProviderId;
    private final String containerProviderType;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> states;
    private final Integer maxResults;
    private final String nextToken;

    private ListVirtualClustersRequest(BuilderImpl builder) {
        super(builder);
        this.containerProviderId = builder.containerProviderId;
        this.containerProviderType = builder.containerProviderType;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.states = builder.states;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String containerProviderId() {
        return this.containerProviderId;
    }

    public ContainerProviderType containerProviderType() {
        return ContainerProviderType.fromValue(this.containerProviderType);
    }

    public String containerProviderTypeAsString() {
        return this.containerProviderType;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<VirtualClusterState> states() {
        return VirtualClusterStatesCopier.copyStringToEnum(this.states);
    }

    public boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public List<String> statesAsStrings() {
        return this.states;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualClustersRequest)) {
            return false;
        }
        ListVirtualClustersRequest other = (ListVirtualClustersRequest)((Object)obj);
        return Objects.equals(this.containerProviderId(), other.containerProviderId()) && Objects.equals(this.containerProviderTypeAsString(), other.containerProviderTypeAsString()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListVirtualClustersRequest").add("ContainerProviderId", (Object)this.containerProviderId()).add("ContainerProviderType", (Object)this.containerProviderTypeAsString()).add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("States", this.hasStates() ? this.statesAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerProviderId": {
                return Optional.ofNullable(clazz.cast(this.containerProviderId()));
            }
            case "containerProviderType": {
                return Optional.ofNullable(clazz.cast(this.containerProviderTypeAsString()));
            }
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualClustersRequest, T> g) {
        return obj -> g.apply((ListVirtualClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String containerProviderId;
        private String containerProviderType;
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualClustersRequest model) {
            super(model);
            this.containerProviderId(model.containerProviderId);
            this.containerProviderType(model.containerProviderType);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.statesWithStrings(model.states);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getContainerProviderId() {
            return this.containerProviderId;
        }

        @Override
        public final Builder containerProviderId(String containerProviderId) {
            this.containerProviderId = containerProviderId;
            return this;
        }

        public final void setContainerProviderId(String containerProviderId) {
            this.containerProviderId = containerProviderId;
        }

        public final String getContainerProviderType() {
            return this.containerProviderType;
        }

        @Override
        public final Builder containerProviderType(String containerProviderType) {
            this.containerProviderType = containerProviderType;
            return this;
        }

        @Override
        public final Builder containerProviderType(ContainerProviderType containerProviderType) {
            this.containerProviderType(containerProviderType == null ? null : containerProviderType.toString());
            return this;
        }

        public final void setContainerProviderType(String containerProviderType) {
            this.containerProviderType = containerProviderType;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = VirtualClusterStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<VirtualClusterState> states) {
            this.states = VirtualClusterStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(VirtualClusterState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = VirtualClusterStatesCopier.copy(states);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualClustersRequest build() {
            return new ListVirtualClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualClustersRequest> {
        public Builder containerProviderId(String var1);

        public Builder containerProviderType(String var1);

        public Builder containerProviderType(ContainerProviderType var1);

        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<VirtualClusterState> var1);

        public Builder states(VirtualClusterState ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

