/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndpointState {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    TERMINATED_WITH_ERRORS("TERMINATED_WITH_ERRORS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndpointState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndpointState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointState> knownValues() {
        return Stream.of(EndpointState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

