/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedEndpointsResponse extends EmrContainersResponse implements
        ToCopyableBuilder<ListManagedEndpointsResponse.Builder, ListManagedEndpointsResponse> {
    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField
            .<List<Endpoint>> builder(MarshallingType.LIST)
            .memberName("endpoints")
            .getter(getter(ListManagedEndpointsResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Endpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListManagedEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Endpoint> endpoints;

    private final String nextToken;

    private ListManagedEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The managed endpoints to be listed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The managed endpoints to be listed.
     */
    public final List<Endpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The token for the next set of endpoints to return.
     * </p>
     * 
     * @return The token for the next set of endpoints to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedEndpointsResponse)) {
            return false;
        }
        ListManagedEndpointsResponse other = (ListManagedEndpointsResponse) obj;
        return hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedEndpointsResponse").add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedEndpointsResponse, T> g) {
        return obj -> g.apply((ListManagedEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedEndpointsResponse> {
        /**
         * <p>
         * The managed endpoints to be listed.
         * </p>
         * 
         * @param endpoints
         *        The managed endpoints to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<Endpoint> endpoints);

        /**
         * <p>
         * The managed endpoints to be listed.
         * </p>
         * 
         * @param endpoints
         *        The managed endpoints to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Endpoint... endpoints);

        /**
         * <p>
         * The managed endpoints to be listed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Endpoint>.Builder} avoiding the need to
         * create one manually via {@link List<Endpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Endpoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoints(List<Endpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<Endpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<Endpoint>)
         */
        Builder endpoints(Consumer<Endpoint.Builder>... endpoints);

        /**
         * <p>
         * The token for the next set of endpoints to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of endpoints to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EmrContainersResponse.BuilderImpl implements Builder {
        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedEndpointsResponse model) {
            super(model);
            endpoints(model.endpoints);
            nextToken(model.nextToken);
        }

        public final List<Endpoint.Builder> getEndpoints() {
            List<Endpoint.Builder> result = EndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> Endpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointsCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListManagedEndpointsResponse build() {
            return new ListManagedEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
