/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelJobRunResponse extends EmrContainersResponse implements
        ToCopyableBuilder<CancelJobRunResponse.Builder, CancelJobRunResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CancelJobRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterId").getter(getter(CancelJobRunResponse::virtualClusterId))
            .setter(setter(Builder::virtualClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualClusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            VIRTUAL_CLUSTER_ID_FIELD));

    private final String id;

    private final String virtualClusterId;

    private CancelJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.virtualClusterId = builder.virtualClusterId;
    }

    /**
     * <p>
     * The output contains the ID of the cancelled job run.
     * </p>
     * 
     * @return The output contains the ID of the cancelled job run.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The output contains the virtual cluster ID for which the job run is cancelled.
     * </p>
     * 
     * @return The output contains the virtual cluster ID for which the job run is cancelled.
     */
    public final String virtualClusterId() {
        return virtualClusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobRunResponse)) {
            return false;
        }
        CancelJobRunResponse other = (CancelJobRunResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(virtualClusterId(), other.virtualClusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelJobRunResponse").add("Id", id()).add("VirtualClusterId", virtualClusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "virtualClusterId":
            return Optional.ofNullable(clazz.cast(virtualClusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelJobRunResponse, T> g) {
        return obj -> g.apply((CancelJobRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelJobRunResponse> {
        /**
         * <p>
         * The output contains the ID of the cancelled job run.
         * </p>
         * 
         * @param id
         *        The output contains the ID of the cancelled job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The output contains the virtual cluster ID for which the job run is cancelled.
         * </p>
         * 
         * @param virtualClusterId
         *        The output contains the virtual cluster ID for which the job run is cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterId(String virtualClusterId);
    }

    static final class BuilderImpl extends EmrContainersResponse.BuilderImpl implements Builder {
        private String id;

        private String virtualClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobRunResponse model) {
            super(model);
            id(model.id);
            virtualClusterId(model.virtualClusterId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVirtualClusterId() {
            return virtualClusterId;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        @Transient
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        @Override
        public CancelJobRunResponse build() {
            return new CancelJobRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
