/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entity representing certificate data generated for managed endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(Certificate::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateData").getter(getter(Certificate::certificateData)).setter(setter(Builder::certificateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String certificateData;

    private Certificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateData = builder.certificateData;
    }

    /**
     * <p>
     * The ARN of the certificate generated for managed endpoint.
     * </p>
     * 
     * @return The ARN of the certificate generated for managed endpoint.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The base64 encoded PEM certificate data generated for managed endpoint.
     * </p>
     * 
     * @return The base64 encoded PEM certificate data generated for managed endpoint.
     */
    public final String certificateData() {
        return certificateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateData(), other.certificateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("CertificateArn", certificateArn()).add("CertificateData", certificateData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateData":
            return Optional.ofNullable(clazz.cast(certificateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The ARN of the certificate generated for managed endpoint.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate generated for managed endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The base64 encoded PEM certificate data generated for managed endpoint.
         * </p>
         * 
         * @param certificateData
         *        The base64 encoded PEM certificate data generated for managed endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateData(String certificateData);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateData;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateArn(model.certificateArn);
            certificateData(model.certificateData);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateData() {
            return certificateData;
        }

        public final void setCertificateData(String certificateData) {
            this.certificateData = certificateData;
        }

        @Override
        public final Builder certificateData(String certificateData) {
            this.certificateData = certificateData;
            return this;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
