/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersAsyncClient;
import software.amazon.awssdk.services.emrcontainers.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrcontainers.model.Endpoint;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsResponse;

public class ListManagedEndpointsPublisher
implements SdkPublisher<ListManagedEndpointsResponse> {
    private final EmrContainersAsyncClient client;
    private final ListManagedEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedEndpointsPublisher(EmrContainersAsyncClient client, ListManagedEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedEndpointsPublisher(EmrContainersAsyncClient client, ListManagedEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Endpoint> endpoints() {
        Function<ListManagedEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedEndpointsResponseFetcher
    implements AsyncPageFetcher<ListManagedEndpointsResponse> {
        private ListManagedEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedEndpointsResponse> nextPage(ListManagedEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedEndpointsPublisher.this.client.listManagedEndpoints(ListManagedEndpointsPublisher.this.firstRequest);
            }
            return ListManagedEndpointsPublisher.this.client.listManagedEndpoints((ListManagedEndpointsRequest)((Object)ListManagedEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

