/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emrcontainers.DefaultEmrContainersBaseClientBuilder;
import software.amazon.awssdk.services.emrcontainers.DefaultEmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClientBuilder;
import software.amazon.awssdk.services.emrcontainers.EmrContainersServiceClientConfiguration;
import software.amazon.awssdk.services.emrcontainers.endpoints.EmrContainersEndpointProvider;

@SdkInternalApi
final class DefaultEmrContainersClientBuilder
extends DefaultEmrContainersBaseClientBuilder<EmrContainersClientBuilder, EmrContainersClient>
implements EmrContainersClientBuilder {
    DefaultEmrContainersClientBuilder() {
    }

    @Override
    public DefaultEmrContainersClientBuilder endpointProvider(EmrContainersEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EmrContainersClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEmrContainersClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        EmrContainersServiceClientConfiguration serviceClientConfiguration = EmrContainersServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEmrContainersClient(serviceClientConfiguration, clientConfiguration);
    }
}

