/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointState {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    TERMINATED_WITH_ERRORS("TERMINATED_WITH_ERRORS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointState> VALUE_MAP;
    private final String value;

    private EndpointState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointState> knownValues() {
        EnumSet<EndpointState> knownValues = EnumSet.allOf(EndpointState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointState.class, EndpointState::toString);
    }
}

