/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchMonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchMonitoringConfiguration> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CloudWatchMonitoringConfiguration.getter(CloudWatchMonitoringConfiguration::logGroupName)).setter(CloudWatchMonitoringConfiguration.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamNamePrefix").getter(CloudWatchMonitoringConfiguration.getter(CloudWatchMonitoringConfiguration::logStreamNamePrefix)).setter(CloudWatchMonitoringConfiguration.setter(Builder::logStreamNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logGroupName;
    private final String logStreamNamePrefix;

    private CloudWatchMonitoringConfiguration(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMonitoringConfiguration)) {
            return false;
        }
        CloudWatchMonitoringConfiguration other = (CloudWatchMonitoringConfiguration)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchMonitoringConfiguration").add("LogGroupName", (Object)this.logGroupName()).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMonitoringConfiguration, T> g) {
        return obj -> g.apply((CloudWatchMonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMonitoringConfiguration model) {
            this.logGroupName(model.logGroupName);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public CloudWatchMonitoringConfiguration build() {
            return new CloudWatchMonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchMonitoringConfiguration> {
        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);
    }
}

