/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations related to the security configuration for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityConfigurationData implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityConfigurationData.Builder, SecurityConfigurationData> {
    private static final SdkField<AuthorizationConfiguration> AUTHORIZATION_CONFIGURATION_FIELD = SdkField
            .<AuthorizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("authorizationConfiguration")
            .getter(getter(SecurityConfigurationData::authorizationConfiguration))
            .setter(setter(Builder::authorizationConfiguration))
            .constructor(AuthorizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTHORIZATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AuthorizationConfiguration authorizationConfiguration;

    private SecurityConfigurationData(BuilderImpl builder) {
        this.authorizationConfiguration = builder.authorizationConfiguration;
    }

    /**
     * <p>
     * Authorization-related configuration input for the security configuration.
     * </p>
     * 
     * @return Authorization-related configuration input for the security configuration.
     */
    public final AuthorizationConfiguration authorizationConfiguration() {
        return authorizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfigurationData)) {
            return false;
        }
        SecurityConfigurationData other = (SecurityConfigurationData) obj;
        return Objects.equals(authorizationConfiguration(), other.authorizationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityConfigurationData").add("AuthorizationConfiguration", authorizationConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationConfiguration":
            return Optional.ofNullable(clazz.cast(authorizationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityConfigurationData, T> g) {
        return obj -> g.apply((SecurityConfigurationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityConfigurationData> {
        /**
         * <p>
         * Authorization-related configuration input for the security configuration.
         * </p>
         * 
         * @param authorizationConfiguration
         *        Authorization-related configuration input for the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationConfiguration(AuthorizationConfiguration authorizationConfiguration);

        /**
         * <p>
         * Authorization-related configuration input for the security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AuthorizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizationConfiguration(AuthorizationConfiguration)}.
         * 
         * @param authorizationConfiguration
         *        a consumer that will call methods on {@link AuthorizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationConfiguration(AuthorizationConfiguration)
         */
        default Builder authorizationConfiguration(Consumer<AuthorizationConfiguration.Builder> authorizationConfiguration) {
            return authorizationConfiguration(AuthorizationConfiguration.builder().applyMutation(authorizationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AuthorizationConfiguration authorizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfigurationData model) {
            authorizationConfiguration(model.authorizationConfiguration);
        }

        public final AuthorizationConfiguration.Builder getAuthorizationConfiguration() {
            return authorizationConfiguration != null ? authorizationConfiguration.toBuilder() : null;
        }

        public final void setAuthorizationConfiguration(AuthorizationConfiguration.BuilderImpl authorizationConfiguration) {
            this.authorizationConfiguration = authorizationConfiguration != null ? authorizationConfiguration.build() : null;
        }

        @Override
        public final Builder authorizationConfiguration(AuthorizationConfiguration authorizationConfiguration) {
            this.authorizationConfiguration = authorizationConfiguration;
            return this;
        }

        @Override
        public SecurityConfigurationData build() {
            return new SecurityConfigurationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
