/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the container used for a job run or a managed endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerInfo implements SdkPojo, Serializable, ToCopyableBuilder<ContainerInfo.Builder, ContainerInfo> {
    private static final SdkField<EksInfo> EKS_INFO_FIELD = SdkField.<EksInfo> builder(MarshallingType.SDK_POJO)
            .memberName("eksInfo").getter(getter(ContainerInfo::eksInfo)).setter(setter(Builder::eksInfo))
            .constructor(EksInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final EksInfo eksInfo;

    private final Type type;

    private ContainerInfo(BuilderImpl builder) {
        this.eksInfo = builder.eksInfo;
        this.type = builder.type;
    }

    /**
     * <p>
     * The information about the Amazon EKS cluster.
     * </p>
     * 
     * @return The information about the Amazon EKS cluster.
     */
    public final EksInfo eksInfo() {
        return eksInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo other = (ContainerInfo) obj;
        return Objects.equals(eksInfo(), other.eksInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerInfo").add("EksInfo", eksInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksInfo":
            return Optional.ofNullable(clazz.cast(eksInfo()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #eksInfo()} initialized to the given value.
     *
     * <p>
     * The information about the Amazon EKS cluster.
     * </p>
     * 
     * @param eksInfo
     *        The information about the Amazon EKS cluster.
     */
    public static ContainerInfo fromEksInfo(EksInfo eksInfo) {
        return builder().eksInfo(eksInfo).build();
    }

    /**
     * Create an instance of this class with {@link #eksInfo()} initialized to the given value.
     *
     * <p>
     * The information about the Amazon EKS cluster.
     * </p>
     * 
     * @param eksInfo
     *        The information about the Amazon EKS cluster.
     */
    public static ContainerInfo fromEksInfo(Consumer<EksInfo.Builder> eksInfo) {
        EksInfo.Builder builder = EksInfo.builder();
        eksInfo.accept(builder);
        return fromEksInfo(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInfo, T> g) {
        return obj -> g.apply((ContainerInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerInfo> {
        /**
         * <p>
         * The information about the Amazon EKS cluster.
         * </p>
         * 
         * @param eksInfo
         *        The information about the Amazon EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksInfo(EksInfo eksInfo);

        /**
         * <p>
         * The information about the Amazon EKS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksInfo.Builder} avoiding the need to
         * create one manually via {@link EksInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #eksInfo(EksInfo)}.
         * 
         * @param eksInfo
         *        a consumer that will call methods on {@link EksInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksInfo(EksInfo)
         */
        default Builder eksInfo(Consumer<EksInfo.Builder> eksInfo) {
            return eksInfo(EksInfo.builder().applyMutation(eksInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EksInfo eksInfo;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInfo model) {
            eksInfo(model.eksInfo);
        }

        public final EksInfo.Builder getEksInfo() {
            return eksInfo != null ? eksInfo.toBuilder() : null;
        }

        public final void setEksInfo(EksInfo.BuilderImpl eksInfo) {
            Object oldValue = this.eksInfo;
            this.eksInfo = eksInfo != null ? eksInfo.build() : null;
            handleUnionValueChange(Type.EKS_INFO, oldValue, this.eksInfo);
        }

        @Override
        public final Builder eksInfo(EksInfo eksInfo) {
            Object oldValue = this.eksInfo;
            this.eksInfo = eksInfo;
            handleUnionValueChange(Type.EKS_INFO, oldValue, this.eksInfo);
            return this;
        }

        @Override
        public ContainerInfo build() {
            return new ContainerInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContainerInfo#type()
     */
    public enum Type {
        EKS_INFO,

        UNKNOWN_TO_SDK_VERSION
    }
}
