/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.CertificateProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TLSCertificateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TLSCertificateConfiguration> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProviderType").getter(TLSCertificateConfiguration.getter(TLSCertificateConfiguration::certificateProviderTypeAsString)).setter(TLSCertificateConfiguration.setter(Builder::certificateProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderType").build()}).build();
    private static final SdkField<String> PUBLIC_CERTIFICATE_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicCertificateSecretArn").getter(TLSCertificateConfiguration.getter(TLSCertificateConfiguration::publicCertificateSecretArn)).setter(TLSCertificateConfiguration.setter(Builder::publicCertificateSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicCertificateSecretArn").build()}).build();
    private static final SdkField<String> PRIVATE_CERTIFICATE_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateCertificateSecretArn").getter(TLSCertificateConfiguration.getter(TLSCertificateConfiguration::privateCertificateSecretArn)).setter(TLSCertificateConfiguration.setter(Builder::privateCertificateSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateCertificateSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PROVIDER_TYPE_FIELD, PUBLIC_CERTIFICATE_SECRET_ARN_FIELD, PRIVATE_CERTIFICATE_SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateProviderType", CERTIFICATE_PROVIDER_TYPE_FIELD);
            this.put("publicCertificateSecretArn", PUBLIC_CERTIFICATE_SECRET_ARN_FIELD);
            this.put("privateCertificateSecretArn", PRIVATE_CERTIFICATE_SECRET_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String certificateProviderType;
    private final String publicCertificateSecretArn;
    private final String privateCertificateSecretArn;

    private TLSCertificateConfiguration(BuilderImpl builder) {
        this.certificateProviderType = builder.certificateProviderType;
        this.publicCertificateSecretArn = builder.publicCertificateSecretArn;
        this.privateCertificateSecretArn = builder.privateCertificateSecretArn;
    }

    public final CertificateProviderType certificateProviderType() {
        return CertificateProviderType.fromValue(this.certificateProviderType);
    }

    public final String certificateProviderTypeAsString() {
        return this.certificateProviderType;
    }

    public final String publicCertificateSecretArn() {
        return this.publicCertificateSecretArn;
    }

    public final String privateCertificateSecretArn() {
        return this.privateCertificateSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicCertificateSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateCertificateSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLSCertificateConfiguration)) {
            return false;
        }
        TLSCertificateConfiguration other = (TLSCertificateConfiguration)obj;
        return Objects.equals(this.certificateProviderTypeAsString(), other.certificateProviderTypeAsString()) && Objects.equals(this.publicCertificateSecretArn(), other.publicCertificateSecretArn()) && Objects.equals(this.privateCertificateSecretArn(), other.privateCertificateSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"TLSCertificateConfiguration").add("CertificateProviderType", (Object)this.certificateProviderTypeAsString()).add("PublicCertificateSecretArn", (Object)this.publicCertificateSecretArn()).add("PrivateCertificateSecretArn", (Object)this.privateCertificateSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateProviderType": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderTypeAsString()));
            }
            case "publicCertificateSecretArn": {
                return Optional.ofNullable(clazz.cast(this.publicCertificateSecretArn()));
            }
            case "privateCertificateSecretArn": {
                return Optional.ofNullable(clazz.cast(this.privateCertificateSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TLSCertificateConfiguration, T> g) {
        return obj -> g.apply((TLSCertificateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateProviderType;
        private String publicCertificateSecretArn;
        private String privateCertificateSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TLSCertificateConfiguration model) {
            this.certificateProviderType(model.certificateProviderType);
            this.publicCertificateSecretArn(model.publicCertificateSecretArn);
            this.privateCertificateSecretArn(model.privateCertificateSecretArn);
        }

        public final String getCertificateProviderType() {
            return this.certificateProviderType;
        }

        public final void setCertificateProviderType(String certificateProviderType) {
            this.certificateProviderType = certificateProviderType;
        }

        @Override
        public final Builder certificateProviderType(String certificateProviderType) {
            this.certificateProviderType = certificateProviderType;
            return this;
        }

        @Override
        public final Builder certificateProviderType(CertificateProviderType certificateProviderType) {
            this.certificateProviderType(certificateProviderType == null ? null : certificateProviderType.toString());
            return this;
        }

        public final String getPublicCertificateSecretArn() {
            return this.publicCertificateSecretArn;
        }

        public final void setPublicCertificateSecretArn(String publicCertificateSecretArn) {
            this.publicCertificateSecretArn = publicCertificateSecretArn;
        }

        @Override
        public final Builder publicCertificateSecretArn(String publicCertificateSecretArn) {
            this.publicCertificateSecretArn = publicCertificateSecretArn;
            return this;
        }

        public final String getPrivateCertificateSecretArn() {
            return this.privateCertificateSecretArn;
        }

        public final void setPrivateCertificateSecretArn(String privateCertificateSecretArn) {
            this.privateCertificateSecretArn = privateCertificateSecretArn;
        }

        @Override
        public final Builder privateCertificateSecretArn(String privateCertificateSecretArn) {
            this.privateCertificateSecretArn = privateCertificateSecretArn;
            return this;
        }

        public TLSCertificateConfiguration build() {
            return new TLSCertificateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TLSCertificateConfiguration> {
        public Builder certificateProviderType(String var1);

        public Builder certificateProviderType(CertificateProviderType var1);

        public Builder publicCertificateSecretArn(String var1);

        public Builder privateCertificateSecretArn(String var1);
    }
}

