/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Authorization-related configuration inputs for the security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationConfiguration.Builder, AuthorizationConfiguration> {
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField
            .<LakeFormationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("lakeFormationConfiguration")
            .getter(getter(AuthorizationConfiguration::lakeFormationConfiguration))
            .setter(setter(Builder::lakeFormationConfiguration))
            .constructor(LakeFormationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakeFormationConfiguration").build())
            .build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(AuthorizationConfiguration::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAKE_FORMATION_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LakeFormationConfiguration lakeFormationConfiguration;

    private final EncryptionConfiguration encryptionConfiguration;

    private AuthorizationConfiguration(BuilderImpl builder) {
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * Lake Formation related configuration inputs for the security configuration.
     * </p>
     * 
     * @return Lake Formation related configuration inputs for the security configuration.
     */
    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return lakeFormationConfiguration;
    }

    /**
     * <p>
     * Encryption-related configuration input for the security configuration.
     * </p>
     * 
     * @return Encryption-related configuration input for the security configuration.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationConfiguration)) {
            return false;
        }
        AuthorizationConfiguration other = (AuthorizationConfiguration) obj;
        return Objects.equals(lakeFormationConfiguration(), other.lakeFormationConfiguration())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationConfiguration").add("LakeFormationConfiguration", lakeFormationConfiguration())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lakeFormationConfiguration":
            return Optional.ofNullable(clazz.cast(lakeFormationConfiguration()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lakeFormationConfiguration", LAKE_FORMATION_CONFIGURATION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationConfiguration, T> g) {
        return obj -> g.apply((AuthorizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationConfiguration> {
        /**
         * <p>
         * Lake Formation related configuration inputs for the security configuration.
         * </p>
         * 
         * @param lakeFormationConfiguration
         *        Lake Formation related configuration inputs for the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration);

        /**
         * <p>
         * Lake Formation related configuration inputs for the security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LakeFormationConfiguration.Builder}
         * avoiding the need to create one manually via {@link LakeFormationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LakeFormationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #lakeFormationConfiguration(LakeFormationConfiguration)}.
         * 
         * @param lakeFormationConfiguration
         *        a consumer that will call methods on {@link LakeFormationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationConfiguration(LakeFormationConfiguration)
         */
        default Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return lakeFormationConfiguration(LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)
                    .build());
        }

        /**
         * <p>
         * Encryption-related configuration input for the security configuration.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Encryption-related configuration input for the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Encryption-related configuration input for the security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LakeFormationConfiguration lakeFormationConfiguration;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationConfiguration model) {
            lakeFormationConfiguration(model.lakeFormationConfiguration);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return lakeFormationConfiguration != null ? lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
        }

        @Override
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public AuthorizationConfiguration build() {
            return new AuthorizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
