/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations related to encryption for the security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private static final SdkField<InTransitEncryptionConfiguration> IN_TRANSIT_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<InTransitEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("inTransitEncryptionConfiguration")
            .getter(getter(EncryptionConfiguration::inTransitEncryptionConfiguration))
            .setter(setter(Builder::inTransitEncryptionConfiguration))
            .constructor(InTransitEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inTransitEncryptionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_TRANSIT_ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InTransitEncryptionConfiguration inTransitEncryptionConfiguration;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.inTransitEncryptionConfiguration = builder.inTransitEncryptionConfiguration;
    }

    /**
     * <p>
     * In-transit encryption-related input for the security configuration.
     * </p>
     * 
     * @return In-transit encryption-related input for the security configuration.
     */
    public final InTransitEncryptionConfiguration inTransitEncryptionConfiguration() {
        return inTransitEncryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inTransitEncryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(inTransitEncryptionConfiguration(), other.inTransitEncryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfiguration")
                .add("InTransitEncryptionConfiguration", inTransitEncryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inTransitEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(inTransitEncryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inTransitEncryptionConfiguration", IN_TRANSIT_ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * In-transit encryption-related input for the security configuration.
         * </p>
         * 
         * @param inTransitEncryptionConfiguration
         *        In-transit encryption-related input for the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inTransitEncryptionConfiguration(InTransitEncryptionConfiguration inTransitEncryptionConfiguration);

        /**
         * <p>
         * In-transit encryption-related input for the security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link InTransitEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link InTransitEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InTransitEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inTransitEncryptionConfiguration(InTransitEncryptionConfiguration)}.
         * 
         * @param inTransitEncryptionConfiguration
         *        a consumer that will call methods on {@link InTransitEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inTransitEncryptionConfiguration(InTransitEncryptionConfiguration)
         */
        default Builder inTransitEncryptionConfiguration(
                Consumer<InTransitEncryptionConfiguration.Builder> inTransitEncryptionConfiguration) {
            return inTransitEncryptionConfiguration(InTransitEncryptionConfiguration.builder()
                    .applyMutation(inTransitEncryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InTransitEncryptionConfiguration inTransitEncryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            inTransitEncryptionConfiguration(model.inTransitEncryptionConfiguration);
        }

        public final InTransitEncryptionConfiguration.Builder getInTransitEncryptionConfiguration() {
            return inTransitEncryptionConfiguration != null ? inTransitEncryptionConfiguration.toBuilder() : null;
        }

        public final void setInTransitEncryptionConfiguration(
                InTransitEncryptionConfiguration.BuilderImpl inTransitEncryptionConfiguration) {
            this.inTransitEncryptionConfiguration = inTransitEncryptionConfiguration != null ? inTransitEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder inTransitEncryptionConfiguration(InTransitEncryptionConfiguration inTransitEncryptionConfiguration) {
            this.inTransitEncryptionConfiguration = inTransitEncryptionConfiguration;
            return this;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
