/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations related to in-transit encryption for the security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InTransitEncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InTransitEncryptionConfiguration.Builder, InTransitEncryptionConfiguration> {
    private static final SdkField<TLSCertificateConfiguration> TLS_CERTIFICATE_CONFIGURATION_FIELD = SdkField
            .<TLSCertificateConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("tlsCertificateConfiguration")
            .getter(getter(InTransitEncryptionConfiguration::tlsCertificateConfiguration))
            .setter(setter(Builder::tlsCertificateConfiguration))
            .constructor(TLSCertificateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsCertificateConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TLS_CERTIFICATE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TLSCertificateConfiguration tlsCertificateConfiguration;

    private InTransitEncryptionConfiguration(BuilderImpl builder) {
        this.tlsCertificateConfiguration = builder.tlsCertificateConfiguration;
    }

    /**
     * <p>
     * TLS certificate-related configuration input for the security configuration.
     * </p>
     * 
     * @return TLS certificate-related configuration input for the security configuration.
     */
    public final TLSCertificateConfiguration tlsCertificateConfiguration() {
        return tlsCertificateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tlsCertificateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InTransitEncryptionConfiguration)) {
            return false;
        }
        InTransitEncryptionConfiguration other = (InTransitEncryptionConfiguration) obj;
        return Objects.equals(tlsCertificateConfiguration(), other.tlsCertificateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InTransitEncryptionConfiguration")
                .add("TlsCertificateConfiguration", tlsCertificateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tlsCertificateConfiguration":
            return Optional.ofNullable(clazz.cast(tlsCertificateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tlsCertificateConfiguration", TLS_CERTIFICATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InTransitEncryptionConfiguration, T> g) {
        return obj -> g.apply((InTransitEncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InTransitEncryptionConfiguration> {
        /**
         * <p>
         * TLS certificate-related configuration input for the security configuration.
         * </p>
         * 
         * @param tlsCertificateConfiguration
         *        TLS certificate-related configuration input for the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCertificateConfiguration(TLSCertificateConfiguration tlsCertificateConfiguration);

        /**
         * <p>
         * TLS certificate-related configuration input for the security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TLSCertificateConfiguration.Builder}
         * avoiding the need to create one manually via {@link TLSCertificateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSCertificateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsCertificateConfiguration(TLSCertificateConfiguration)}.
         * 
         * @param tlsCertificateConfiguration
         *        a consumer that will call methods on {@link TLSCertificateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsCertificateConfiguration(TLSCertificateConfiguration)
         */
        default Builder tlsCertificateConfiguration(Consumer<TLSCertificateConfiguration.Builder> tlsCertificateConfiguration) {
            return tlsCertificateConfiguration(TLSCertificateConfiguration.builder().applyMutation(tlsCertificateConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TLSCertificateConfiguration tlsCertificateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InTransitEncryptionConfiguration model) {
            tlsCertificateConfiguration(model.tlsCertificateConfiguration);
        }

        public final TLSCertificateConfiguration.Builder getTlsCertificateConfiguration() {
            return tlsCertificateConfiguration != null ? tlsCertificateConfiguration.toBuilder() : null;
        }

        public final void setTlsCertificateConfiguration(TLSCertificateConfiguration.BuilderImpl tlsCertificateConfiguration) {
            this.tlsCertificateConfiguration = tlsCertificateConfiguration != null ? tlsCertificateConfiguration.build() : null;
        }

        @Override
        public final Builder tlsCertificateConfiguration(TLSCertificateConfiguration tlsCertificateConfiguration) {
            this.tlsCertificateConfiguration = tlsCertificateConfiguration;
            return this;
        }

        @Override
        public InTransitEncryptionConfiguration build() {
            return new InTransitEncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
