/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either
 * sparkSqlJobDriver or sparkSubmitJobDriver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDriver implements SdkPojo, Serializable, ToCopyableBuilder<JobDriver.Builder, JobDriver> {
    private static final SdkField<SparkSubmitJobDriver> SPARK_SUBMIT_JOB_DRIVER_FIELD = SdkField
            .<SparkSubmitJobDriver> builder(MarshallingType.SDK_POJO).memberName("sparkSubmitJobDriver")
            .getter(getter(JobDriver::sparkSubmitJobDriver)).setter(setter(Builder::sparkSubmitJobDriver))
            .constructor(SparkSubmitJobDriver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSubmitJobDriver").build())
            .build();

    private static final SdkField<SparkSqlJobDriver> SPARK_SQL_JOB_DRIVER_FIELD = SdkField
            .<SparkSqlJobDriver> builder(MarshallingType.SDK_POJO).memberName("sparkSqlJobDriver")
            .getter(getter(JobDriver::sparkSqlJobDriver)).setter(setter(Builder::sparkSqlJobDriver))
            .constructor(SparkSqlJobDriver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSqlJobDriver").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPARK_SUBMIT_JOB_DRIVER_FIELD,
            SPARK_SQL_JOB_DRIVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SparkSubmitJobDriver sparkSubmitJobDriver;

    private final SparkSqlJobDriver sparkSqlJobDriver;

    private JobDriver(BuilderImpl builder) {
        this.sparkSubmitJobDriver = builder.sparkSubmitJobDriver;
        this.sparkSqlJobDriver = builder.sparkSqlJobDriver;
    }

    /**
     * <p>
     * The job driver parameters specified for spark submit.
     * </p>
     * 
     * @return The job driver parameters specified for spark submit.
     */
    public final SparkSubmitJobDriver sparkSubmitJobDriver() {
        return sparkSubmitJobDriver;
    }

    /**
     * <p>
     * The job driver for job type.
     * </p>
     * 
     * @return The job driver for job type.
     */
    public final SparkSqlJobDriver sparkSqlJobDriver() {
        return sparkSqlJobDriver;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sparkSubmitJobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(sparkSqlJobDriver());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDriver)) {
            return false;
        }
        JobDriver other = (JobDriver) obj;
        return Objects.equals(sparkSubmitJobDriver(), other.sparkSubmitJobDriver())
                && Objects.equals(sparkSqlJobDriver(), other.sparkSqlJobDriver());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDriver").add("SparkSubmitJobDriver", sparkSubmitJobDriver())
                .add("SparkSqlJobDriver", sparkSqlJobDriver()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sparkSubmitJobDriver":
            return Optional.ofNullable(clazz.cast(sparkSubmitJobDriver()));
        case "sparkSqlJobDriver":
            return Optional.ofNullable(clazz.cast(sparkSqlJobDriver()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sparkSubmitJobDriver", SPARK_SUBMIT_JOB_DRIVER_FIELD);
        map.put("sparkSqlJobDriver", SPARK_SQL_JOB_DRIVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDriver, T> g) {
        return obj -> g.apply((JobDriver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDriver> {
        /**
         * <p>
         * The job driver parameters specified for spark submit.
         * </p>
         * 
         * @param sparkSubmitJobDriver
         *        The job driver parameters specified for spark submit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSubmitJobDriver(SparkSubmitJobDriver sparkSubmitJobDriver);

        /**
         * <p>
         * The job driver parameters specified for spark submit.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkSubmitJobDriver.Builder} avoiding
         * the need to create one manually via {@link SparkSubmitJobDriver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkSubmitJobDriver.Builder#build()} is called immediately and
         * its result is passed to {@link #sparkSubmitJobDriver(SparkSubmitJobDriver)}.
         * 
         * @param sparkSubmitJobDriver
         *        a consumer that will call methods on {@link SparkSubmitJobDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkSubmitJobDriver(SparkSubmitJobDriver)
         */
        default Builder sparkSubmitJobDriver(Consumer<SparkSubmitJobDriver.Builder> sparkSubmitJobDriver) {
            return sparkSubmitJobDriver(SparkSubmitJobDriver.builder().applyMutation(sparkSubmitJobDriver).build());
        }

        /**
         * <p>
         * The job driver for job type.
         * </p>
         * 
         * @param sparkSqlJobDriver
         *        The job driver for job type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSqlJobDriver(SparkSqlJobDriver sparkSqlJobDriver);

        /**
         * <p>
         * The job driver for job type.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkSqlJobDriver.Builder} avoiding the
         * need to create one manually via {@link SparkSqlJobDriver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkSqlJobDriver.Builder#build()} is called immediately and its
         * result is passed to {@link #sparkSqlJobDriver(SparkSqlJobDriver)}.
         * 
         * @param sparkSqlJobDriver
         *        a consumer that will call methods on {@link SparkSqlJobDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkSqlJobDriver(SparkSqlJobDriver)
         */
        default Builder sparkSqlJobDriver(Consumer<SparkSqlJobDriver.Builder> sparkSqlJobDriver) {
            return sparkSqlJobDriver(SparkSqlJobDriver.builder().applyMutation(sparkSqlJobDriver).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SparkSubmitJobDriver sparkSubmitJobDriver;

        private SparkSqlJobDriver sparkSqlJobDriver;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDriver model) {
            sparkSubmitJobDriver(model.sparkSubmitJobDriver);
            sparkSqlJobDriver(model.sparkSqlJobDriver);
        }

        public final SparkSubmitJobDriver.Builder getSparkSubmitJobDriver() {
            return sparkSubmitJobDriver != null ? sparkSubmitJobDriver.toBuilder() : null;
        }

        public final void setSparkSubmitJobDriver(SparkSubmitJobDriver.BuilderImpl sparkSubmitJobDriver) {
            this.sparkSubmitJobDriver = sparkSubmitJobDriver != null ? sparkSubmitJobDriver.build() : null;
        }

        @Override
        public final Builder sparkSubmitJobDriver(SparkSubmitJobDriver sparkSubmitJobDriver) {
            this.sparkSubmitJobDriver = sparkSubmitJobDriver;
            return this;
        }

        public final SparkSqlJobDriver.Builder getSparkSqlJobDriver() {
            return sparkSqlJobDriver != null ? sparkSqlJobDriver.toBuilder() : null;
        }

        public final void setSparkSqlJobDriver(SparkSqlJobDriver.BuilderImpl sparkSqlJobDriver) {
            this.sparkSqlJobDriver = sparkSqlJobDriver != null ? sparkSqlJobDriver.build() : null;
        }

        @Override
        public final Builder sparkSqlJobDriver(SparkSqlJobDriver sparkSqlJobDriver) {
            this.sparkSqlJobDriver = sparkSqlJobDriver;
            return this;
        }

        @Override
        public JobDriver build() {
            return new JobDriver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
