/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lake Formation related configuration inputs for the security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationConfiguration.Builder, LakeFormationConfiguration> {
    private static final SdkField<String> AUTHORIZED_SESSION_TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizedSessionTagValue").getter(getter(LakeFormationConfiguration::authorizedSessionTagValue))
            .setter(setter(Builder::authorizedSessionTagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedSessionTagValue").build())
            .build();

    private static final SdkField<SecureNamespaceInfo> SECURE_NAMESPACE_INFO_FIELD = SdkField
            .<SecureNamespaceInfo> builder(MarshallingType.SDK_POJO).memberName("secureNamespaceInfo")
            .getter(getter(LakeFormationConfiguration::secureNamespaceInfo)).setter(setter(Builder::secureNamespaceInfo))
            .constructor(SecureNamespaceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secureNamespaceInfo").build())
            .build();

    private static final SdkField<String> QUERY_ENGINE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryEngineRoleArn").getter(getter(LakeFormationConfiguration::queryEngineRoleArn))
            .setter(setter(Builder::queryEngineRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEngineRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZED_SESSION_TAG_VALUE_FIELD, SECURE_NAMESPACE_INFO_FIELD, QUERY_ENGINE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizedSessionTagValue;

    private final SecureNamespaceInfo secureNamespaceInfo;

    private final String queryEngineRoleArn;

    private LakeFormationConfiguration(BuilderImpl builder) {
        this.authorizedSessionTagValue = builder.authorizedSessionTagValue;
        this.secureNamespaceInfo = builder.secureNamespaceInfo;
        this.queryEngineRoleArn = builder.queryEngineRoleArn;
    }

    /**
     * <p>
     * The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
     * </p>
     * 
     * @return The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
     */
    public final String authorizedSessionTagValue() {
        return authorizedSessionTagValue;
    }

    /**
     * <p>
     * The namespace input of the system job.
     * </p>
     * 
     * @return The namespace input of the system job.
     */
    public final SecureNamespaceInfo secureNamespaceInfo() {
        return secureNamespaceInfo;
    }

    /**
     * <p>
     * The query engine IAM role ARN that is tied to the secure Spark job. The <code>QueryEngine</code> role assumes the
     * <code>JobExecutionRole</code> to execute all the Lake Formation calls.
     * </p>
     * 
     * @return The query engine IAM role ARN that is tied to the secure Spark job. The <code>QueryEngine</code> role
     *         assumes the <code>JobExecutionRole</code> to execute all the Lake Formation calls.
     */
    public final String queryEngineRoleArn() {
        return queryEngineRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizedSessionTagValue());
        hashCode = 31 * hashCode + Objects.hashCode(secureNamespaceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(queryEngineRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationConfiguration)) {
            return false;
        }
        LakeFormationConfiguration other = (LakeFormationConfiguration) obj;
        return Objects.equals(authorizedSessionTagValue(), other.authorizedSessionTagValue())
                && Objects.equals(secureNamespaceInfo(), other.secureNamespaceInfo())
                && Objects.equals(queryEngineRoleArn(), other.queryEngineRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationConfiguration").add("AuthorizedSessionTagValue", authorizedSessionTagValue())
                .add("SecureNamespaceInfo", secureNamespaceInfo()).add("QueryEngineRoleArn", queryEngineRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizedSessionTagValue":
            return Optional.ofNullable(clazz.cast(authorizedSessionTagValue()));
        case "secureNamespaceInfo":
            return Optional.ofNullable(clazz.cast(secureNamespaceInfo()));
        case "queryEngineRoleArn":
            return Optional.ofNullable(clazz.cast(queryEngineRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizedSessionTagValue", AUTHORIZED_SESSION_TAG_VALUE_FIELD);
        map.put("secureNamespaceInfo", SECURE_NAMESPACE_INFO_FIELD);
        map.put("queryEngineRoleArn", QUERY_ENGINE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationConfiguration, T> g) {
        return obj -> g.apply((LakeFormationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationConfiguration> {
        /**
         * <p>
         * The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
         * </p>
         * 
         * @param authorizedSessionTagValue
         *        The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedSessionTagValue(String authorizedSessionTagValue);

        /**
         * <p>
         * The namespace input of the system job.
         * </p>
         * 
         * @param secureNamespaceInfo
         *        The namespace input of the system job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureNamespaceInfo(SecureNamespaceInfo secureNamespaceInfo);

        /**
         * <p>
         * The namespace input of the system job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecureNamespaceInfo.Builder} avoiding the
         * need to create one manually via {@link SecureNamespaceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecureNamespaceInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #secureNamespaceInfo(SecureNamespaceInfo)}.
         * 
         * @param secureNamespaceInfo
         *        a consumer that will call methods on {@link SecureNamespaceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secureNamespaceInfo(SecureNamespaceInfo)
         */
        default Builder secureNamespaceInfo(Consumer<SecureNamespaceInfo.Builder> secureNamespaceInfo) {
            return secureNamespaceInfo(SecureNamespaceInfo.builder().applyMutation(secureNamespaceInfo).build());
        }

        /**
         * <p>
         * The query engine IAM role ARN that is tied to the secure Spark job. The <code>QueryEngine</code> role assumes
         * the <code>JobExecutionRole</code> to execute all the Lake Formation calls.
         * </p>
         * 
         * @param queryEngineRoleArn
         *        The query engine IAM role ARN that is tied to the secure Spark job. The <code>QueryEngine</code> role
         *        assumes the <code>JobExecutionRole</code> to execute all the Lake Formation calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryEngineRoleArn(String queryEngineRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String authorizedSessionTagValue;

        private SecureNamespaceInfo secureNamespaceInfo;

        private String queryEngineRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationConfiguration model) {
            authorizedSessionTagValue(model.authorizedSessionTagValue);
            secureNamespaceInfo(model.secureNamespaceInfo);
            queryEngineRoleArn(model.queryEngineRoleArn);
        }

        public final String getAuthorizedSessionTagValue() {
            return authorizedSessionTagValue;
        }

        public final void setAuthorizedSessionTagValue(String authorizedSessionTagValue) {
            this.authorizedSessionTagValue = authorizedSessionTagValue;
        }

        @Override
        public final Builder authorizedSessionTagValue(String authorizedSessionTagValue) {
            this.authorizedSessionTagValue = authorizedSessionTagValue;
            return this;
        }

        public final SecureNamespaceInfo.Builder getSecureNamespaceInfo() {
            return secureNamespaceInfo != null ? secureNamespaceInfo.toBuilder() : null;
        }

        public final void setSecureNamespaceInfo(SecureNamespaceInfo.BuilderImpl secureNamespaceInfo) {
            this.secureNamespaceInfo = secureNamespaceInfo != null ? secureNamespaceInfo.build() : null;
        }

        @Override
        public final Builder secureNamespaceInfo(SecureNamespaceInfo secureNamespaceInfo) {
            this.secureNamespaceInfo = secureNamespaceInfo;
            return this;
        }

        public final String getQueryEngineRoleArn() {
            return queryEngineRoleArn;
        }

        public final void setQueryEngineRoleArn(String queryEngineRoleArn) {
            this.queryEngineRoleArn = queryEngineRoleArn;
        }

        @Override
        public final Builder queryEngineRoleArn(String queryEngineRoleArn) {
            this.queryEngineRoleArn = queryEngineRoleArn;
            return this;
        }

        @Override
        public LakeFormationConfiguration build() {
            return new LakeFormationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
