/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobTemplatesResponse extends EmrContainersResponse implements
        ToCopyableBuilder<ListJobTemplatesResponse.Builder, ListJobTemplatesResponse> {
    private static final SdkField<List<JobTemplate>> TEMPLATES_FIELD = SdkField
            .<List<JobTemplate>> builder(MarshallingType.LIST)
            .memberName("templates")
            .getter(getter(ListJobTemplatesResponse::templates))
            .setter(setter(Builder::templates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<JobTemplate> templates;

    private final String nextToken;

    private ListJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templates = builder.templates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Templates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTemplates() {
        return templates != null && !(templates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This output lists information about the specified job templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplates} method.
     * </p>
     * 
     * @return This output lists information about the specified job templates.
     */
    public final List<JobTemplate> templates() {
        return templates;
    }

    /**
     * <p>
     * This output displays the token for the next set of job templates.
     * </p>
     * 
     * @return This output displays the token for the next set of job templates.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplates() ? templates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesResponse)) {
            return false;
        }
        ListJobTemplatesResponse other = (ListJobTemplatesResponse) obj;
        return hasTemplates() == other.hasTemplates() && Objects.equals(templates(), other.templates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobTemplatesResponse").add("Templates", hasTemplates() ? templates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templates":
            return Optional.ofNullable(clazz.cast(templates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templates", TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesResponse, T> g) {
        return obj -> g.apply((ListJobTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobTemplatesResponse> {
        /**
         * <p>
         * This output lists information about the specified job templates.
         * </p>
         * 
         * @param templates
         *        This output lists information about the specified job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templates(Collection<JobTemplate> templates);

        /**
         * <p>
         * This output lists information about the specified job templates.
         * </p>
         * 
         * @param templates
         *        This output lists information about the specified job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templates(JobTemplate... templates);

        /**
         * <p>
         * This output lists information about the specified job templates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emrcontainers.model.JobTemplate.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emrcontainers.model.JobTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emrcontainers.model.JobTemplate.Builder#build()} is called immediately
         * and its result is passed to {@link #templates(List<JobTemplate>)}.
         * 
         * @param templates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emrcontainers.model.JobTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templates(java.util.Collection<JobTemplate>)
         */
        Builder templates(Consumer<JobTemplate.Builder>... templates);

        /**
         * <p>
         * This output displays the token for the next set of job templates.
         * </p>
         * 
         * @param nextToken
         *        This output displays the token for the next set of job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EmrContainersResponse.BuilderImpl implements Builder {
        private List<JobTemplate> templates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesResponse model) {
            super(model);
            templates(model.templates);
            nextToken(model.nextToken);
        }

        public final List<JobTemplate.Builder> getTemplates() {
            List<JobTemplate.Builder> result = JobTemplatesCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<JobTemplate.BuilderImpl> templates) {
            this.templates = JobTemplatesCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<JobTemplate> templates) {
            this.templates = JobTemplatesCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(JobTemplate... templates) {
            templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<JobTemplate.Builder>... templates) {
            templates(Stream.of(templates).map(c -> JobTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobTemplatesResponse build() {
            return new ListJobTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
