/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualClustersRequest extends EmrContainersRequest implements
        ToCopyableBuilder<ListVirtualClustersRequest.Builder, ListVirtualClustersRequest> {
    private static final SdkField<String> CONTAINER_PROVIDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerProviderId").getter(getter(ListVirtualClustersRequest::containerProviderId))
            .setter(setter(Builder::containerProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("containerProviderId").build())
            .build();

    private static final SdkField<String> CONTAINER_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerProviderType").getter(getter(ListVirtualClustersRequest::containerProviderTypeAsString))
            .setter(setter(Builder::containerProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("containerProviderType").build())
            .build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAfter")
            .getter(getter(ListVirtualClustersRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdBefore")
            .getter(getter(ListVirtualClustersRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(ListVirtualClustersRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVirtualClustersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualClustersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> EKS_ACCESS_ENTRY_INTEGRATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("eksAccessEntryIntegrated")
            .getter(getter(ListVirtualClustersRequest::eksAccessEntryIntegrated))
            .setter(setter(Builder::eksAccessEntryIntegrated))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eksAccessEntryIntegrated")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PROVIDER_ID_FIELD,
            CONTAINER_PROVIDER_TYPE_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, STATES_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, EKS_ACCESS_ENTRY_INTEGRATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String containerProviderId;

    private final String containerProviderType;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final List<String> states;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean eksAccessEntryIntegrated;

    private ListVirtualClustersRequest(BuilderImpl builder) {
        super(builder);
        this.containerProviderId = builder.containerProviderId;
        this.containerProviderType = builder.containerProviderType;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.states = builder.states;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.eksAccessEntryIntegrated = builder.eksAccessEntryIntegrated;
    }

    /**
     * <p>
     * The container provider ID of the virtual cluster.
     * </p>
     * 
     * @return The container provider ID of the virtual cluster.
     */
    public final String containerProviderId() {
        return containerProviderId;
    }

    /**
     * <p>
     * The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #containerProviderType} will return {@link ContainerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #containerProviderTypeAsString}.
     * </p>
     * 
     * @return The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
     * @see ContainerProviderType
     */
    public final ContainerProviderType containerProviderType() {
        return ContainerProviderType.fromValue(containerProviderType);
    }

    /**
     * <p>
     * The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #containerProviderType} will return {@link ContainerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #containerProviderTypeAsString}.
     * </p>
     * 
     * @return The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
     * @see ContainerProviderType
     */
    public final String containerProviderTypeAsString() {
        return containerProviderType;
    }

    /**
     * <p>
     * The date and time after which the virtual clusters are created.
     * </p>
     * 
     * @return The date and time after which the virtual clusters are created.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * The date and time before which the virtual clusters are created.
     * </p>
     * 
     * @return The date and time before which the virtual clusters are created.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The states of the requested virtual clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The states of the requested virtual clusters.
     */
    public final List<VirtualClusterState> states() {
        return VirtualClusterStatesCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states of the requested virtual clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The states of the requested virtual clusters.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The maximum number of virtual clusters that can be listed.
     * </p>
     * 
     * @return The maximum number of virtual clusters that can be listed.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of virtual clusters to return.
     * </p>
     * 
     * @return The token for the next set of virtual clusters to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Optional Boolean that specifies whether the operation should return the virtual clusters that have the access
     * entry integration enabled or disabled. If not specified, the operation returns all applicable virtual clusters.
     * </p>
     * 
     * @return Optional Boolean that specifies whether the operation should return the virtual clusters that have the
     *         access entry integration enabled or disabled. If not specified, the operation returns all applicable
     *         virtual clusters.
     */
    public final Boolean eksAccessEntryIntegrated() {
        return eksAccessEntryIntegrated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(containerProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(eksAccessEntryIntegrated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualClustersRequest)) {
            return false;
        }
        ListVirtualClustersRequest other = (ListVirtualClustersRequest) obj;
        return Objects.equals(containerProviderId(), other.containerProviderId())
                && Objects.equals(containerProviderTypeAsString(), other.containerProviderTypeAsString())
                && Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore())
                && hasStates() == other.hasStates() && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(eksAccessEntryIntegrated(), other.eksAccessEntryIntegrated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualClustersRequest").add("ContainerProviderId", containerProviderId())
                .add("ContainerProviderType", containerProviderTypeAsString()).add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("States", hasStates() ? statesAsStrings() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("EksAccessEntryIntegrated", eksAccessEntryIntegrated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerProviderId":
            return Optional.ofNullable(clazz.cast(containerProviderId()));
        case "containerProviderType":
            return Optional.ofNullable(clazz.cast(containerProviderTypeAsString()));
        case "createdAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "createdBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "eksAccessEntryIntegrated":
            return Optional.ofNullable(clazz.cast(eksAccessEntryIntegrated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerProviderId", CONTAINER_PROVIDER_ID_FIELD);
        map.put("containerProviderType", CONTAINER_PROVIDER_TYPE_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("states", STATES_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("eksAccessEntryIntegrated", EKS_ACCESS_ENTRY_INTEGRATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualClustersRequest, T> g) {
        return obj -> g.apply((ListVirtualClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualClustersRequest> {
        /**
         * <p>
         * The container provider ID of the virtual cluster.
         * </p>
         * 
         * @param containerProviderId
         *        The container provider ID of the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProviderId(String containerProviderId);

        /**
         * <p>
         * The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
         * </p>
         * 
         * @param containerProviderType
         *        The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
         * @see ContainerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerProviderType
         */
        Builder containerProviderType(String containerProviderType);

        /**
         * <p>
         * The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
         * </p>
         * 
         * @param containerProviderType
         *        The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.
         * @see ContainerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerProviderType
         */
        Builder containerProviderType(ContainerProviderType containerProviderType);

        /**
         * <p>
         * The date and time after which the virtual clusters are created.
         * </p>
         * 
         * @param createdAfter
         *        The date and time after which the virtual clusters are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The date and time before which the virtual clusters are created.
         * </p>
         * 
         * @param createdBefore
         *        The date and time before which the virtual clusters are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The states of the requested virtual clusters.
         * </p>
         * 
         * @param states
         *        The states of the requested virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The states of the requested virtual clusters.
         * </p>
         * 
         * @param states
         *        The states of the requested virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The states of the requested virtual clusters.
         * </p>
         * 
         * @param states
         *        The states of the requested virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<VirtualClusterState> states);

        /**
         * <p>
         * The states of the requested virtual clusters.
         * </p>
         * 
         * @param states
         *        The states of the requested virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(VirtualClusterState... states);

        /**
         * <p>
         * The maximum number of virtual clusters that can be listed.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of virtual clusters that can be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of virtual clusters to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of virtual clusters to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Optional Boolean that specifies whether the operation should return the virtual clusters that have the access
         * entry integration enabled or disabled. If not specified, the operation returns all applicable virtual
         * clusters.
         * </p>
         * 
         * @param eksAccessEntryIntegrated
         *        Optional Boolean that specifies whether the operation should return the virtual clusters that have the
         *        access entry integration enabled or disabled. If not specified, the operation returns all applicable
         *        virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksAccessEntryIntegrated(Boolean eksAccessEntryIntegrated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String containerProviderId;

        private String containerProviderType;

        private Instant createdAfter;

        private Instant createdBefore;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private Boolean eksAccessEntryIntegrated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualClustersRequest model) {
            super(model);
            containerProviderId(model.containerProviderId);
            containerProviderType(model.containerProviderType);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            statesWithStrings(model.states);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            eksAccessEntryIntegrated(model.eksAccessEntryIntegrated);
        }

        public final String getContainerProviderId() {
            return containerProviderId;
        }

        public final void setContainerProviderId(String containerProviderId) {
            this.containerProviderId = containerProviderId;
        }

        @Override
        public final Builder containerProviderId(String containerProviderId) {
            this.containerProviderId = containerProviderId;
            return this;
        }

        public final String getContainerProviderType() {
            return containerProviderType;
        }

        public final void setContainerProviderType(String containerProviderType) {
            this.containerProviderType = containerProviderType;
        }

        @Override
        public final Builder containerProviderType(String containerProviderType) {
            this.containerProviderType = containerProviderType;
            return this;
        }

        @Override
        public final Builder containerProviderType(ContainerProviderType containerProviderType) {
            this.containerProviderType(containerProviderType == null ? null : containerProviderType.toString());
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = VirtualClusterStatesCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = VirtualClusterStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<VirtualClusterState> states) {
            this.states = VirtualClusterStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(VirtualClusterState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getEksAccessEntryIntegrated() {
            return eksAccessEntryIntegrated;
        }

        public final void setEksAccessEntryIntegrated(Boolean eksAccessEntryIntegrated) {
            this.eksAccessEntryIntegrated = eksAccessEntryIntegrated;
        }

        @Override
        public final Builder eksAccessEntryIntegrated(Boolean eksAccessEntryIntegrated) {
            this.eksAccessEntryIntegrated = eksAccessEntryIntegrated;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVirtualClustersRequest build() {
            return new ListVirtualClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
