/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration setting for monitoring.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfiguration.Builder, MonitoringConfiguration> {
    private static final SdkField<String> PERSISTENT_APP_UI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("persistentAppUI").getter(getter(MonitoringConfiguration::persistentAppUIAsString))
            .setter(setter(Builder::persistentAppUI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentAppUI").build()).build();

    private static final SdkField<CloudWatchMonitoringConfiguration> CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD = SdkField
            .<CloudWatchMonitoringConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cloudWatchMonitoringConfiguration")
            .getter(getter(MonitoringConfiguration::cloudWatchMonitoringConfiguration))
            .setter(setter(Builder::cloudWatchMonitoringConfiguration))
            .constructor(CloudWatchMonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchMonitoringConfiguration")
                    .build()).build();

    private static final SdkField<S3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField
            .<S3MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration")
            .getter(getter(MonitoringConfiguration::s3MonitoringConfiguration))
            .setter(setter(Builder::s3MonitoringConfiguration)).constructor(S3MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build())
            .build();

    private static final SdkField<ContainerLogRotationConfiguration> CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD = SdkField
            .<ContainerLogRotationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("containerLogRotationConfiguration")
            .getter(getter(MonitoringConfiguration::containerLogRotationConfiguration))
            .setter(setter(Builder::containerLogRotationConfiguration))
            .constructor(ContainerLogRotationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerLogRotationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_FIELD,
            CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD, S3_MONITORING_CONFIGURATION_FIELD,
            CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String persistentAppUI;

    private final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;

    private final S3MonitoringConfiguration s3MonitoringConfiguration;

    private final ContainerLogRotationConfiguration containerLogRotationConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.persistentAppUI = builder.persistentAppUI;
        this.cloudWatchMonitoringConfiguration = builder.cloudWatchMonitoringConfiguration;
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
        this.containerLogRotationConfiguration = builder.containerLogRotationConfiguration;
    }

    /**
     * <p>
     * Monitoring configurations for the persistent application UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistentAppUI}
     * will return {@link PersistentAppUI#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #persistentAppUIAsString}.
     * </p>
     * 
     * @return Monitoring configurations for the persistent application UI.
     * @see PersistentAppUI
     */
    public final PersistentAppUI persistentAppUI() {
        return PersistentAppUI.fromValue(persistentAppUI);
    }

    /**
     * <p>
     * Monitoring configurations for the persistent application UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistentAppUI}
     * will return {@link PersistentAppUI#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #persistentAppUIAsString}.
     * </p>
     * 
     * @return Monitoring configurations for the persistent application UI.
     * @see PersistentAppUI
     */
    public final String persistentAppUIAsString() {
        return persistentAppUI;
    }

    /**
     * <p>
     * Monitoring configurations for CloudWatch.
     * </p>
     * 
     * @return Monitoring configurations for CloudWatch.
     */
    public final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration() {
        return cloudWatchMonitoringConfiguration;
    }

    /**
     * <p>
     * Amazon S3 configuration for monitoring log publishing.
     * </p>
     * 
     * @return Amazon S3 configuration for monitoring log publishing.
     */
    public final S3MonitoringConfiguration s3MonitoringConfiguration() {
        return s3MonitoringConfiguration;
    }

    /**
     * <p>
     * Enable or disable container log rotation.
     * </p>
     * 
     * @return Enable or disable container log rotation.
     */
    public final ContainerLogRotationConfiguration containerLogRotationConfiguration() {
        return containerLogRotationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUIAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3MonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(containerLogRotationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration) obj;
        return Objects.equals(persistentAppUIAsString(), other.persistentAppUIAsString())
                && Objects.equals(cloudWatchMonitoringConfiguration(), other.cloudWatchMonitoringConfiguration())
                && Objects.equals(s3MonitoringConfiguration(), other.s3MonitoringConfiguration())
                && Objects.equals(containerLogRotationConfiguration(), other.containerLogRotationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfiguration").add("PersistentAppUI", persistentAppUIAsString())
                .add("CloudWatchMonitoringConfiguration", cloudWatchMonitoringConfiguration())
                .add("S3MonitoringConfiguration", s3MonitoringConfiguration())
                .add("ContainerLogRotationConfiguration", containerLogRotationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "persistentAppUI":
            return Optional.ofNullable(clazz.cast(persistentAppUIAsString()));
        case "cloudWatchMonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchMonitoringConfiguration()));
        case "s3MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(s3MonitoringConfiguration()));
        case "containerLogRotationConfiguration":
            return Optional.ofNullable(clazz.cast(containerLogRotationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("persistentAppUI", PERSISTENT_APP_UI_FIELD);
        map.put("cloudWatchMonitoringConfiguration", CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD);
        map.put("s3MonitoringConfiguration", S3_MONITORING_CONFIGURATION_FIELD);
        map.put("containerLogRotationConfiguration", CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfiguration> {
        /**
         * <p>
         * Monitoring configurations for the persistent application UI.
         * </p>
         * 
         * @param persistentAppUI
         *        Monitoring configurations for the persistent application UI.
         * @see PersistentAppUI
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersistentAppUI
         */
        Builder persistentAppUI(String persistentAppUI);

        /**
         * <p>
         * Monitoring configurations for the persistent application UI.
         * </p>
         * 
         * @param persistentAppUI
         *        Monitoring configurations for the persistent application UI.
         * @see PersistentAppUI
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersistentAppUI
         */
        Builder persistentAppUI(PersistentAppUI persistentAppUI);

        /**
         * <p>
         * Monitoring configurations for CloudWatch.
         * </p>
         * 
         * @param cloudWatchMonitoringConfiguration
         *        Monitoring configurations for CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration);

        /**
         * <p>
         * Monitoring configurations for CloudWatch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchMonitoringConfiguration.Builder} avoiding the need to create one manually via
         * {@link CloudWatchMonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchMonitoringConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration)}.
         * 
         * @param cloudWatchMonitoringConfiguration
         *        a consumer that will call methods on {@link CloudWatchMonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration)
         */
        default Builder cloudWatchMonitoringConfiguration(
                Consumer<CloudWatchMonitoringConfiguration.Builder> cloudWatchMonitoringConfiguration) {
            return cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration.builder()
                    .applyMutation(cloudWatchMonitoringConfiguration).build());
        }

        /**
         * <p>
         * Amazon S3 configuration for monitoring log publishing.
         * </p>
         * 
         * @param s3MonitoringConfiguration
         *        Amazon S3 configuration for monitoring log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration);

        /**
         * <p>
         * Amazon S3 configuration for monitoring log publishing.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3MonitoringConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3MonitoringConfiguration(S3MonitoringConfiguration)}.
         * 
         * @param s3MonitoringConfiguration
         *        a consumer that will call methods on {@link S3MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3MonitoringConfiguration(S3MonitoringConfiguration)
         */
        default Builder s3MonitoringConfiguration(Consumer<S3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return s3MonitoringConfiguration(S3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration).build());
        }

        /**
         * <p>
         * Enable or disable container log rotation.
         * </p>
         * 
         * @param containerLogRotationConfiguration
         *        Enable or disable container log rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerLogRotationConfiguration(ContainerLogRotationConfiguration containerLogRotationConfiguration);

        /**
         * <p>
         * Enable or disable container log rotation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerLogRotationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ContainerLogRotationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerLogRotationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #containerLogRotationConfiguration(ContainerLogRotationConfiguration)}.
         * 
         * @param containerLogRotationConfiguration
         *        a consumer that will call methods on {@link ContainerLogRotationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerLogRotationConfiguration(ContainerLogRotationConfiguration)
         */
        default Builder containerLogRotationConfiguration(
                Consumer<ContainerLogRotationConfiguration.Builder> containerLogRotationConfiguration) {
            return containerLogRotationConfiguration(ContainerLogRotationConfiguration.builder()
                    .applyMutation(containerLogRotationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String persistentAppUI;

        private CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;

        private S3MonitoringConfiguration s3MonitoringConfiguration;

        private ContainerLogRotationConfiguration containerLogRotationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            persistentAppUI(model.persistentAppUI);
            cloudWatchMonitoringConfiguration(model.cloudWatchMonitoringConfiguration);
            s3MonitoringConfiguration(model.s3MonitoringConfiguration);
            containerLogRotationConfiguration(model.containerLogRotationConfiguration);
        }

        public final String getPersistentAppUI() {
            return persistentAppUI;
        }

        public final void setPersistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
        }

        @Override
        public final Builder persistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
            return this;
        }

        @Override
        public final Builder persistentAppUI(PersistentAppUI persistentAppUI) {
            this.persistentAppUI(persistentAppUI == null ? null : persistentAppUI.toString());
            return this;
        }

        public final CloudWatchMonitoringConfiguration.Builder getCloudWatchMonitoringConfiguration() {
            return cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchMonitoringConfiguration(
                CloudWatchMonitoringConfiguration.BuilderImpl cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration;
            return this;
        }

        public final S3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return s3MonitoringConfiguration != null ? s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(S3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public final ContainerLogRotationConfiguration.Builder getContainerLogRotationConfiguration() {
            return containerLogRotationConfiguration != null ? containerLogRotationConfiguration.toBuilder() : null;
        }

        public final void setContainerLogRotationConfiguration(
                ContainerLogRotationConfiguration.BuilderImpl containerLogRotationConfiguration) {
            this.containerLogRotationConfiguration = containerLogRotationConfiguration != null ? containerLogRotationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder containerLogRotationConfiguration(ContainerLogRotationConfiguration containerLogRotationConfiguration) {
            this.containerLogRotationConfiguration = containerLogRotationConfiguration;
            return this;
        }

        @Override
        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
