/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the retry policy that the job runs on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryPolicyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetryPolicyConfiguration.Builder, RetryPolicyConfiguration> {
    private static final SdkField<Integer> MAX_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxAttempts").getter(getter(RetryPolicyConfiguration::maxAttempts)).setter(setter(Builder::maxAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAttempts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ATTEMPTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxAttempts;

    private RetryPolicyConfiguration(BuilderImpl builder) {
        this.maxAttempts = builder.maxAttempts;
    }

    /**
     * <p>
     * The maximum number of attempts on the job's driver.
     * </p>
     * 
     * @return The maximum number of attempts on the job's driver.
     */
    public final Integer maxAttempts() {
        return maxAttempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxAttempts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicyConfiguration)) {
            return false;
        }
        RetryPolicyConfiguration other = (RetryPolicyConfiguration) obj;
        return Objects.equals(maxAttempts(), other.maxAttempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryPolicyConfiguration").add("MaxAttempts", maxAttempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxAttempts":
            return Optional.ofNullable(clazz.cast(maxAttempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxAttempts", MAX_ATTEMPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicyConfiguration, T> g) {
        return obj -> g.apply((RetryPolicyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryPolicyConfiguration> {
        /**
         * <p>
         * The maximum number of attempts on the job's driver.
         * </p>
         * 
         * @param maxAttempts
         *        The maximum number of attempts on the job's driver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAttempts(Integer maxAttempts);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicyConfiguration model) {
            maxAttempts(model.maxAttempts);
        }

        public final Integer getMaxAttempts() {
            return maxAttempts;
        }

        public final void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public final Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Override
        public RetryPolicyConfiguration build() {
            return new RetryPolicyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
