/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inputs related to the security configuration. Security configurations in Amazon EMR on EKS are templates for
 * different security setups. You can use security configurations to configure the Lake Formation integration setup. You
 * can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityConfiguration.Builder, SecurityConfiguration> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SecurityConfiguration::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SecurityConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SecurityConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(SecurityConfiguration::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(SecurityConfiguration::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<SecurityConfigurationData> SECURITY_CONFIGURATION_DATA_FIELD = SdkField
            .<SecurityConfigurationData> builder(MarshallingType.SDK_POJO).memberName("securityConfigurationData")
            .getter(getter(SecurityConfiguration::securityConfigurationData)).setter(setter(Builder::securityConfigurationData))
            .constructor(SecurityConfigurationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigurationData").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SecurityConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, SECURITY_CONFIGURATION_DATA_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final Instant createdAt;

    private final String createdBy;

    private final SecurityConfigurationData securityConfigurationData;

    private final Map<String, String> tags;

    private SecurityConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.securityConfigurationData = builder.securityConfigurationData;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     * 
     * @return The ID of the security configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the security configuration.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the security configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the job run was created.
     * </p>
     * 
     * @return The date and time that the job run was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @return The user who created the job run.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Security configuration inputs for the request.
     * </p>
     * 
     * @return Security configuration inputs for the request.
     */
    public final SecurityConfigurationData securityConfigurationData() {
        return securityConfigurationData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the security configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the security configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfigurationData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfiguration)) {
            return false;
        }
        SecurityConfiguration other = (SecurityConfiguration) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(securityConfigurationData(), other.securityConfigurationData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityConfiguration").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("SecurityConfigurationData", securityConfigurationData()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "securityConfigurationData":
            return Optional.ofNullable(clazz.cast(securityConfigurationData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("securityConfigurationData", SECURITY_CONFIGURATION_DATA_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityConfiguration, T> g) {
        return obj -> g.apply((SecurityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityConfiguration> {
        /**
         * <p>
         * The ID of the security configuration.
         * </p>
         * 
         * @param id
         *        The ID of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the security configuration.
         * </p>
         * 
         * @param name
         *        The name of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the security configuration.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the job run was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the job run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the job run.
         * </p>
         * 
         * @param createdBy
         *        The user who created the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Security configuration inputs for the request.
         * </p>
         * 
         * @param securityConfigurationData
         *        Security configuration inputs for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigurationData(SecurityConfigurationData securityConfigurationData);

        /**
         * <p>
         * Security configuration inputs for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityConfigurationData.Builder}
         * avoiding the need to create one manually via {@link SecurityConfigurationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityConfigurationData.Builder#build()} is called immediately
         * and its result is passed to {@link #securityConfigurationData(SecurityConfigurationData)}.
         * 
         * @param securityConfigurationData
         *        a consumer that will call methods on {@link SecurityConfigurationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfigurationData(SecurityConfigurationData)
         */
        default Builder securityConfigurationData(Consumer<SecurityConfigurationData.Builder> securityConfigurationData) {
            return securityConfigurationData(SecurityConfigurationData.builder().applyMutation(securityConfigurationData).build());
        }

        /**
         * <p>
         * The tags to assign to the security configuration.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private Instant createdAt;

        private String createdBy;

        private SecurityConfigurationData securityConfigurationData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfiguration model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            securityConfigurationData(model.securityConfigurationData);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final SecurityConfigurationData.Builder getSecurityConfigurationData() {
            return securityConfigurationData != null ? securityConfigurationData.toBuilder() : null;
        }

        public final void setSecurityConfigurationData(SecurityConfigurationData.BuilderImpl securityConfigurationData) {
            this.securityConfigurationData = securityConfigurationData != null ? securityConfigurationData.build() : null;
        }

        @Override
        public final Builder securityConfigurationData(SecurityConfigurationData securityConfigurationData) {
            this.securityConfigurationData = securityConfigurationData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public SecurityConfiguration build() {
            return new SecurityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
