/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations related to the TLS certificate for the security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TLSCertificateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TLSCertificateConfiguration.Builder, TLSCertificateConfiguration> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderType").getter(getter(TLSCertificateConfiguration::certificateProviderTypeAsString))
            .setter(setter(Builder::certificateProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderType").build())
            .build();

    private static final SdkField<String> PUBLIC_CERTIFICATE_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("publicCertificateSecretArn")
            .getter(getter(TLSCertificateConfiguration::publicCertificateSecretArn))
            .setter(setter(Builder::publicCertificateSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicCertificateSecretArn").build())
            .build();

    private static final SdkField<String> PRIVATE_CERTIFICATE_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("privateCertificateSecretArn")
            .getter(getter(TLSCertificateConfiguration::privateCertificateSecretArn))
            .setter(setter(Builder::privateCertificateSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateCertificateSecretArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_PROVIDER_TYPE_FIELD, PUBLIC_CERTIFICATE_SECRET_ARN_FIELD, PRIVATE_CERTIFICATE_SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateProviderType;

    private final String publicCertificateSecretArn;

    private final String privateCertificateSecretArn;

    private TLSCertificateConfiguration(BuilderImpl builder) {
        this.certificateProviderType = builder.certificateProviderType;
        this.publicCertificateSecretArn = builder.publicCertificateSecretArn;
        this.privateCertificateSecretArn = builder.privateCertificateSecretArn;
    }

    /**
     * <p>
     * The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateProviderType} will return {@link CertificateProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #certificateProviderTypeAsString}.
     * </p>
     * 
     * @return The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
     * @see CertificateProviderType
     */
    public final CertificateProviderType certificateProviderType() {
        return CertificateProviderType.fromValue(certificateProviderType);
    }

    /**
     * <p>
     * The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateProviderType} will return {@link CertificateProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #certificateProviderTypeAsString}.
     * </p>
     * 
     * @return The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
     * @see CertificateProviderType
     */
    public final String certificateProviderTypeAsString() {
        return certificateProviderType;
    }

    /**
     * <p>
     * Secrets Manager ARN that contains the public TLS certificate contents, used for communication between the user
     * job and the system job.
     * </p>
     * 
     * @return Secrets Manager ARN that contains the public TLS certificate contents, used for communication between the
     *         user job and the system job.
     */
    public final String publicCertificateSecretArn() {
        return publicCertificateSecretArn;
    }

    /**
     * <p>
     * Secrets Manager ARN that contains the private TLS certificate contents, used for communication between the user
     * job and the system job.
     * </p>
     * 
     * @return Secrets Manager ARN that contains the private TLS certificate contents, used for communication between
     *         the user job and the system job.
     */
    public final String privateCertificateSecretArn() {
        return privateCertificateSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicCertificateSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(privateCertificateSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLSCertificateConfiguration)) {
            return false;
        }
        TLSCertificateConfiguration other = (TLSCertificateConfiguration) obj;
        return Objects.equals(certificateProviderTypeAsString(), other.certificateProviderTypeAsString())
                && Objects.equals(publicCertificateSecretArn(), other.publicCertificateSecretArn())
                && Objects.equals(privateCertificateSecretArn(), other.privateCertificateSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TLSCertificateConfiguration").add("CertificateProviderType", certificateProviderTypeAsString())
                .add("PublicCertificateSecretArn", publicCertificateSecretArn())
                .add("PrivateCertificateSecretArn", privateCertificateSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateProviderType":
            return Optional.ofNullable(clazz.cast(certificateProviderTypeAsString()));
        case "publicCertificateSecretArn":
            return Optional.ofNullable(clazz.cast(publicCertificateSecretArn()));
        case "privateCertificateSecretArn":
            return Optional.ofNullable(clazz.cast(privateCertificateSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateProviderType", CERTIFICATE_PROVIDER_TYPE_FIELD);
        map.put("publicCertificateSecretArn", PUBLIC_CERTIFICATE_SECRET_ARN_FIELD);
        map.put("privateCertificateSecretArn", PRIVATE_CERTIFICATE_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TLSCertificateConfiguration, T> g) {
        return obj -> g.apply((TLSCertificateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TLSCertificateConfiguration> {
        /**
         * <p>
         * The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
         * </p>
         * 
         * @param certificateProviderType
         *        The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
         * @see CertificateProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateProviderType
         */
        Builder certificateProviderType(String certificateProviderType);

        /**
         * <p>
         * The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
         * </p>
         * 
         * @param certificateProviderType
         *        The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.
         * @see CertificateProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateProviderType
         */
        Builder certificateProviderType(CertificateProviderType certificateProviderType);

        /**
         * <p>
         * Secrets Manager ARN that contains the public TLS certificate contents, used for communication between the
         * user job and the system job.
         * </p>
         * 
         * @param publicCertificateSecretArn
         *        Secrets Manager ARN that contains the public TLS certificate contents, used for communication between
         *        the user job and the system job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicCertificateSecretArn(String publicCertificateSecretArn);

        /**
         * <p>
         * Secrets Manager ARN that contains the private TLS certificate contents, used for communication between the
         * user job and the system job.
         * </p>
         * 
         * @param privateCertificateSecretArn
         *        Secrets Manager ARN that contains the private TLS certificate contents, used for communication between
         *        the user job and the system job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateCertificateSecretArn(String privateCertificateSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String certificateProviderType;

        private String publicCertificateSecretArn;

        private String privateCertificateSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TLSCertificateConfiguration model) {
            certificateProviderType(model.certificateProviderType);
            publicCertificateSecretArn(model.publicCertificateSecretArn);
            privateCertificateSecretArn(model.privateCertificateSecretArn);
        }

        public final String getCertificateProviderType() {
            return certificateProviderType;
        }

        public final void setCertificateProviderType(String certificateProviderType) {
            this.certificateProviderType = certificateProviderType;
        }

        @Override
        public final Builder certificateProviderType(String certificateProviderType) {
            this.certificateProviderType = certificateProviderType;
            return this;
        }

        @Override
        public final Builder certificateProviderType(CertificateProviderType certificateProviderType) {
            this.certificateProviderType(certificateProviderType == null ? null : certificateProviderType.toString());
            return this;
        }

        public final String getPublicCertificateSecretArn() {
            return publicCertificateSecretArn;
        }

        public final void setPublicCertificateSecretArn(String publicCertificateSecretArn) {
            this.publicCertificateSecretArn = publicCertificateSecretArn;
        }

        @Override
        public final Builder publicCertificateSecretArn(String publicCertificateSecretArn) {
            this.publicCertificateSecretArn = publicCertificateSecretArn;
            return this;
        }

        public final String getPrivateCertificateSecretArn() {
            return privateCertificateSecretArn;
        }

        public final void setPrivateCertificateSecretArn(String privateCertificateSecretArn) {
            this.privateCertificateSecretArn = privateCertificateSecretArn;
        }

        @Override
        public final Builder privateCertificateSecretArn(String privateCertificateSecretArn) {
            this.privateCertificateSecretArn = privateCertificateSecretArn;
            return this;
        }

        @Override
        public TLSCertificateConfiguration build() {
            return new TLSCertificateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
