/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobTemplatesRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, ListJobTemplatesRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(ListJobTemplatesRequest.getter(ListJobTemplatesRequest::createdAfter)).setter(ListJobTemplatesRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(ListJobTemplatesRequest.getter(ListJobTemplatesRequest::createdBefore)).setter(ListJobTemplatesRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListJobTemplatesRequest.getter(ListJobTemplatesRequest::maxResults)).setter(ListJobTemplatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobTemplatesRequest.getter(ListJobTemplatesRequest::nextToken)).setter(ListJobTemplatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListJobTemplatesRequest.memberNameToFieldInitializer();
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final Integer maxResults;
    private final String nextToken;

    private ListJobTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesRequest)) {
            return false;
        }
        ListJobTemplatesRequest other = (ListJobTemplatesRequest)((Object)obj);
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobTemplatesRequest").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesRequest, T> g) {
        return obj -> g.apply((ListJobTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesRequest model) {
            super(model);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobTemplatesRequest build() {
            return new ListJobTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobTemplatesRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

