/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVirtualClusterRequest extends EmrContainersRequest implements
        ToCopyableBuilder<CreateVirtualClusterRequest.Builder, CreateVirtualClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateVirtualClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ContainerProvider> CONTAINER_PROVIDER_FIELD = SdkField
            .<ContainerProvider> builder(MarshallingType.SDK_POJO).memberName("containerProvider")
            .getter(getter(CreateVirtualClusterRequest::containerProvider)).setter(setter(Builder::containerProvider))
            .constructor(ContainerProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerProvider").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateVirtualClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateVirtualClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityConfigurationId").getter(getter(CreateVirtualClusterRequest::securityConfigurationId))
            .setter(setter(Builder::securityConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigurationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONTAINER_PROVIDER_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, SECURITY_CONFIGURATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final ContainerProvider containerProvider;

    private final String clientToken;

    private final Map<String, String> tags;

    private final String securityConfigurationId;

    private CreateVirtualClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.containerProvider = builder.containerProvider;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.securityConfigurationId = builder.securityConfigurationId;
    }

    /**
     * <p>
     * The specified name of the virtual cluster.
     * </p>
     * 
     * @return The specified name of the virtual cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The container provider of the virtual cluster.
     * </p>
     * 
     * @return The container provider of the virtual cluster.
     */
    public final ContainerProvider containerProvider() {
        return containerProvider;
    }

    /**
     * <p>
     * The client token of the virtual cluster.
     * </p>
     * 
     * @return The client token of the virtual cluster.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the virtual cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the virtual cluster.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the security configuration.
     * </p>
     * 
     * @return The ID of the security configuration.
     */
    public final String securityConfigurationId() {
        return securityConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(containerProvider());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityConfigurationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualClusterRequest)) {
            return false;
        }
        CreateVirtualClusterRequest other = (CreateVirtualClusterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(containerProvider(), other.containerProvider())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(securityConfigurationId(), other.securityConfigurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVirtualClusterRequest").add("Name", name()).add("ContainerProvider", containerProvider())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null)
                .add("SecurityConfigurationId", securityConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "containerProvider":
            return Optional.ofNullable(clazz.cast(containerProvider()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "securityConfigurationId":
            return Optional.ofNullable(clazz.cast(securityConfigurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("containerProvider", CONTAINER_PROVIDER_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("securityConfigurationId", SECURITY_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVirtualClusterRequest, T> g) {
        return obj -> g.apply((CreateVirtualClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVirtualClusterRequest> {
        /**
         * <p>
         * The specified name of the virtual cluster.
         * </p>
         * 
         * @param name
         *        The specified name of the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The container provider of the virtual cluster.
         * </p>
         * 
         * @param containerProvider
         *        The container provider of the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProvider(ContainerProvider containerProvider);

        /**
         * <p>
         * The container provider of the virtual cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProvider.Builder} avoiding the
         * need to create one manually via {@link ContainerProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #containerProvider(ContainerProvider)}.
         * 
         * @param containerProvider
         *        a consumer that will call methods on {@link ContainerProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProvider(ContainerProvider)
         */
        default Builder containerProvider(Consumer<ContainerProvider.Builder> containerProvider) {
            return containerProvider(ContainerProvider.builder().applyMutation(containerProvider).build());
        }

        /**
         * <p>
         * The client token of the virtual cluster.
         * </p>
         * 
         * @param clientToken
         *        The client token of the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags assigned to the virtual cluster.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the security configuration.
         * </p>
         * 
         * @param securityConfigurationId
         *        The ID of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigurationId(String securityConfigurationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String name;

        private ContainerProvider containerProvider;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String securityConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualClusterRequest model) {
            super(model);
            name(model.name);
            containerProvider(model.containerProvider);
            clientToken(model.clientToken);
            tags(model.tags);
            securityConfigurationId(model.securityConfigurationId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContainerProvider.Builder getContainerProvider() {
            return containerProvider != null ? containerProvider.toBuilder() : null;
        }

        public final void setContainerProvider(ContainerProvider.BuilderImpl containerProvider) {
            this.containerProvider = containerProvider != null ? containerProvider.build() : null;
        }

        @Override
        public final Builder containerProvider(ContainerProvider containerProvider) {
            this.containerProvider = containerProvider;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSecurityConfigurationId() {
            return securityConfigurationId;
        }

        public final void setSecurityConfigurationId(String securityConfigurationId) {
            this.securityConfigurationId = securityConfigurationId;
        }

        @Override
        public final Builder securityConfigurationId(String securityConfigurationId) {
            this.securityConfigurationId = securityConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualClusterRequest build() {
            return new CreateVirtualClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
