/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the Amazon EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksInfo implements SdkPojo, Serializable, ToCopyableBuilder<EksInfo.Builder, EksInfo> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(EksInfo::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> NODE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeLabel").getter(getter(EksInfo::nodeLabel)).setter(setter(Builder::nodeLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            NODE_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String nodeLabel;

    private EksInfo(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.nodeLabel = builder.nodeLabel;
    }

    /**
     * <p>
     * The namespaces of the Amazon EKS cluster.
     * </p>
     * 
     * @return The namespaces of the Amazon EKS cluster.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The nodeLabel of the nodes where the resources of this virtual cluster can get scheduled. It requires relevant
     * scaling and policy engine addons.
     * </p>
     * 
     * @return The nodeLabel of the nodes where the resources of this virtual cluster can get scheduled. It requires
     *         relevant scaling and policy engine addons.
     */
    public final String nodeLabel() {
        return nodeLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(nodeLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksInfo)) {
            return false;
        }
        EksInfo other = (EksInfo) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(nodeLabel(), other.nodeLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksInfo").add("Namespace", namespace()).add("NodeLabel", nodeLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "nodeLabel":
            return Optional.ofNullable(clazz.cast(nodeLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("nodeLabel", NODE_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksInfo, T> g) {
        return obj -> g.apply((EksInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksInfo> {
        /**
         * <p>
         * The namespaces of the Amazon EKS cluster.
         * </p>
         * 
         * @param namespace
         *        The namespaces of the Amazon EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The nodeLabel of the nodes where the resources of this virtual cluster can get scheduled. It requires
         * relevant scaling and policy engine addons.
         * </p>
         * 
         * @param nodeLabel
         *        The nodeLabel of the nodes where the resources of this virtual cluster can get scheduled. It requires
         *        relevant scaling and policy engine addons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLabel(String nodeLabel);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String nodeLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(EksInfo model) {
            namespace(model.namespace);
            nodeLabel(model.nodeLabel);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getNodeLabel() {
            return nodeLabel;
        }

        public final void setNodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
        }

        @Override
        public final Builder nodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
            return this;
        }

        @Override
        public EksInfo build() {
            return new EksInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
