/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedEndpointSessionCredentialsRequest extends EmrContainersRequest implements
        ToCopyableBuilder<GetManagedEndpointSessionCredentialsRequest.Builder, GetManagedEndpointSessionCredentialsRequest> {
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointIdentifier").getter(getter(GetManagedEndpointSessionCredentialsRequest::endpointIdentifier))
            .setter(setter(Builder::endpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()).build();

    private static final SdkField<String> VIRTUAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterIdentifier")
            .getter(getter(GetManagedEndpointSessionCredentialsRequest::virtualClusterIdentifier))
            .setter(setter(Builder::virtualClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetManagedEndpointSessionCredentialsRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> CREDENTIAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialType").getter(getter(GetManagedEndpointSessionCredentialsRequest::credentialType))
            .setter(setter(Builder::credentialType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialType").build()).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationInSeconds").getter(getter(GetManagedEndpointSessionCredentialsRequest::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()).build();

    private static final SdkField<String> LOG_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logContext").getter(getter(GetManagedEndpointSessionCredentialsRequest::logContext))
            .setter(setter(Builder::logContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logContext").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(GetManagedEndpointSessionCredentialsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDENTIFIER_FIELD,
            VIRTUAL_CLUSTER_IDENTIFIER_FIELD, EXECUTION_ROLE_ARN_FIELD, CREDENTIAL_TYPE_FIELD, DURATION_IN_SECONDS_FIELD,
            LOG_CONTEXT_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointIdentifier;

    private final String virtualClusterIdentifier;

    private final String executionRoleArn;

    private final String credentialType;

    private final Integer durationInSeconds;

    private final String logContext;

    private final String clientToken;

    private GetManagedEndpointSessionCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIdentifier = builder.endpointIdentifier;
        this.virtualClusterIdentifier = builder.virtualClusterIdentifier;
        this.executionRoleArn = builder.executionRoleArn;
        this.credentialType = builder.credentialType;
        this.durationInSeconds = builder.durationInSeconds;
        this.logContext = builder.logContext;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ARN of the managed endpoint for which the request is submitted.
     * </p>
     * 
     * @return The ARN of the managed endpoint for which the request is submitted.
     */
    public final String endpointIdentifier() {
        return endpointIdentifier;
    }

    /**
     * <p>
     * The ARN of the Virtual Cluster which the Managed Endpoint belongs to.
     * </p>
     * 
     * @return The ARN of the Virtual Cluster which the Managed Endpoint belongs to.
     */
    public final String virtualClusterIdentifier() {
        return virtualClusterIdentifier;
    }

    /**
     * <p>
     * The IAM Execution Role ARN that will be used by the job run.
     * </p>
     * 
     * @return The IAM Execution Role ARN that will be used by the job run.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Type of the token requested. Currently supported and default value of this field is “TOKEN.”
     * </p>
     * 
     * @return Type of the token requested. Currently supported and default value of this field is “TOKEN.”
     */
    public final String credentialType() {
        return credentialType;
    }

    /**
     * <p>
     * Duration in seconds for which the session token is valid. The default duration is 15 minutes and the maximum is
     * 12 hours.
     * </p>
     * 
     * @return Duration in seconds for which the session token is valid. The default duration is 15 minutes and the
     *         maximum is 12 hours.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * String identifier used to separate sections of the execution logs uploaded to S3.
     * </p>
     * 
     * @return String identifier used to separate sections of the execution logs uploaded to S3.
     */
    public final String logContext() {
        return logContext;
    }

    /**
     * <p>
     * The client idempotency token of the job run request.
     * </p>
     * 
     * @return The client idempotency token of the job run request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialType());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(logContext());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedEndpointSessionCredentialsRequest)) {
            return false;
        }
        GetManagedEndpointSessionCredentialsRequest other = (GetManagedEndpointSessionCredentialsRequest) obj;
        return Objects.equals(endpointIdentifier(), other.endpointIdentifier())
                && Objects.equals(virtualClusterIdentifier(), other.virtualClusterIdentifier())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(credentialType(), other.credentialType())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(logContext(), other.logContext()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedEndpointSessionCredentialsRequest").add("EndpointIdentifier", endpointIdentifier())
                .add("VirtualClusterIdentifier", virtualClusterIdentifier()).add("ExecutionRoleArn", executionRoleArn())
                .add("CredentialType", credentialType()).add("DurationInSeconds", durationInSeconds())
                .add("LogContext", logContext()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointIdentifier":
            return Optional.ofNullable(clazz.cast(endpointIdentifier()));
        case "virtualClusterIdentifier":
            return Optional.ofNullable(clazz.cast(virtualClusterIdentifier()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "credentialType":
            return Optional.ofNullable(clazz.cast(credentialType()));
        case "durationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "logContext":
            return Optional.ofNullable(clazz.cast(logContext()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointId", ENDPOINT_IDENTIFIER_FIELD);
        map.put("virtualClusterId", VIRTUAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("credentialType", CREDENTIAL_TYPE_FIELD);
        map.put("durationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("logContext", LOG_CONTEXT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedEndpointSessionCredentialsRequest, T> g) {
        return obj -> g.apply((GetManagedEndpointSessionCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrContainersRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedEndpointSessionCredentialsRequest> {
        /**
         * <p>
         * The ARN of the managed endpoint for which the request is submitted.
         * </p>
         * 
         * @param endpointIdentifier
         *        The ARN of the managed endpoint for which the request is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIdentifier(String endpointIdentifier);

        /**
         * <p>
         * The ARN of the Virtual Cluster which the Managed Endpoint belongs to.
         * </p>
         * 
         * @param virtualClusterIdentifier
         *        The ARN of the Virtual Cluster which the Managed Endpoint belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterIdentifier(String virtualClusterIdentifier);

        /**
         * <p>
         * The IAM Execution Role ARN that will be used by the job run.
         * </p>
         * 
         * @param executionRoleArn
         *        The IAM Execution Role ARN that will be used by the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Type of the token requested. Currently supported and default value of this field is “TOKEN.”
         * </p>
         * 
         * @param credentialType
         *        Type of the token requested. Currently supported and default value of this field is “TOKEN.”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialType(String credentialType);

        /**
         * <p>
         * Duration in seconds for which the session token is valid. The default duration is 15 minutes and the maximum
         * is 12 hours.
         * </p>
         * 
         * @param durationInSeconds
         *        Duration in seconds for which the session token is valid. The default duration is 15 minutes and the
         *        maximum is 12 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * String identifier used to separate sections of the execution logs uploaded to S3.
         * </p>
         * 
         * @param logContext
         *        String identifier used to separate sections of the execution logs uploaded to S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logContext(String logContext);

        /**
         * <p>
         * The client idempotency token of the job run request.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token of the job run request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String endpointIdentifier;

        private String virtualClusterIdentifier;

        private String executionRoleArn;

        private String credentialType;

        private Integer durationInSeconds;

        private String logContext;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedEndpointSessionCredentialsRequest model) {
            super(model);
            endpointIdentifier(model.endpointIdentifier);
            virtualClusterIdentifier(model.virtualClusterIdentifier);
            executionRoleArn(model.executionRoleArn);
            credentialType(model.credentialType);
            durationInSeconds(model.durationInSeconds);
            logContext(model.logContext);
            clientToken(model.clientToken);
        }

        public final String getEndpointIdentifier() {
            return endpointIdentifier;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final String getVirtualClusterIdentifier() {
            return virtualClusterIdentifier;
        }

        public final void setVirtualClusterIdentifier(String virtualClusterIdentifier) {
            this.virtualClusterIdentifier = virtualClusterIdentifier;
        }

        @Override
        public final Builder virtualClusterIdentifier(String virtualClusterIdentifier) {
            this.virtualClusterIdentifier = virtualClusterIdentifier;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getCredentialType() {
            return credentialType;
        }

        public final void setCredentialType(String credentialType) {
            this.credentialType = credentialType;
        }

        @Override
        public final Builder credentialType(String credentialType) {
            this.credentialType = credentialType;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getLogContext() {
            return logContext;
        }

        public final void setLogContext(String logContext) {
            this.logContext = logContext;
        }

        @Override
        public final Builder logContext(String logContext) {
            this.logContext = logContext;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetManagedEndpointSessionCredentialsRequest build() {
            return new GetManagedEndpointSessionCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
