/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This entity describes a job template. Job template stores values of StartJobRun API request in a template and can be
 * used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values,
 * enforcing certain values in StartJobRun API request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTemplate implements SdkPojo, Serializable, ToCopyableBuilder<JobTemplate.Builder, JobTemplate> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(JobTemplate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(JobTemplate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(JobTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(JobTemplate::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(JobTemplate::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(JobTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<JobTemplateData> JOB_TEMPLATE_DATA_FIELD = SdkField
            .<JobTemplateData> builder(MarshallingType.SDK_POJO).memberName("jobTemplateData")
            .getter(getter(JobTemplate::jobTemplateData)).setter(setter(Builder::jobTemplateData))
            .constructor(JobTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateData").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(JobTemplate::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> DECRYPTION_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decryptionError").getter(getter(JobTemplate::decryptionError)).setter(setter(Builder::decryptionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, TAGS_FIELD, JOB_TEMPLATE_DATA_FIELD, KMS_KEY_ARN_FIELD,
            DECRYPTION_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final Instant createdAt;

    private final String createdBy;

    private final Map<String, String> tags;

    private final JobTemplateData jobTemplateData;

    private final String kmsKeyArn;

    private final String decryptionError;

    private JobTemplate(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.tags = builder.tags;
        this.jobTemplateData = builder.jobTemplateData;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.decryptionError = builder.decryptionError;
    }

    /**
     * <p>
     * The name of the job template.
     * </p>
     * 
     * @return The name of the job template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the job template.
     * </p>
     * 
     * @return The ID of the job template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the job template.
     * </p>
     * 
     * @return The ARN of the job template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the job template was created.
     * </p>
     * 
     * @return The date and time when the job template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the job template.
     * </p>
     * 
     * @return The user who created the job template.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the job template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The job template data which holds values of StartJobRun API request.
     * </p>
     * 
     * @return The job template data which holds values of StartJobRun API request.
     */
    public final JobTemplateData jobTemplateData() {
        return jobTemplateData;
    }

    /**
     * <p>
     * The KMS key ARN used to encrypt the job template.
     * </p>
     * 
     * @return The KMS key ARN used to encrypt the job template.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The error message in case the decryption of job template fails.
     * </p>
     * 
     * @return The error message in case the decryption of job template fails.
     */
    public final String decryptionError() {
        return decryptionError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(decryptionError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplate)) {
            return false;
        }
        JobTemplate other = (JobTemplate) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(jobTemplateData(), other.jobTemplateData()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(decryptionError(), other.decryptionError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTemplate").add("Name", name()).add("Id", id()).add("Arn", arn())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("Tags", hasTags() ? tags() : null)
                .add("JobTemplateData", jobTemplateData()).add("KmsKeyArn", kmsKeyArn())
                .add("DecryptionError", decryptionError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "jobTemplateData":
            return Optional.ofNullable(clazz.cast(jobTemplateData()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "decryptionError":
            return Optional.ofNullable(clazz.cast(decryptionError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("jobTemplateData", JOB_TEMPLATE_DATA_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("decryptionError", DECRYPTION_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobTemplate, T> g) {
        return obj -> g.apply((JobTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTemplate> {
        /**
         * <p>
         * The name of the job template.
         * </p>
         * 
         * @param name
         *        The name of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the job template.
         * </p>
         * 
         * @param id
         *        The ID of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the job template.
         * </p>
         * 
         * @param arn
         *        The ARN of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the job template was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the job template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the job template.
         * </p>
         * 
         * @param createdBy
         *        The user who created the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The tags assigned to the job template.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The job template data which holds values of StartJobRun API request.
         * </p>
         * 
         * @param jobTemplateData
         *        The job template data which holds values of StartJobRun API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateData(JobTemplateData jobTemplateData);

        /**
         * <p>
         * The job template data which holds values of StartJobRun API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobTemplateData.Builder} avoiding the
         * need to create one manually via {@link JobTemplateData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobTemplateData.Builder#build()} is called immediately and its
         * result is passed to {@link #jobTemplateData(JobTemplateData)}.
         * 
         * @param jobTemplateData
         *        a consumer that will call methods on {@link JobTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTemplateData(JobTemplateData)
         */
        default Builder jobTemplateData(Consumer<JobTemplateData.Builder> jobTemplateData) {
            return jobTemplateData(JobTemplateData.builder().applyMutation(jobTemplateData).build());
        }

        /**
         * <p>
         * The KMS key ARN used to encrypt the job template.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key ARN used to encrypt the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The error message in case the decryption of job template fails.
         * </p>
         * 
         * @param decryptionError
         *        The error message in case the decryption of job template fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryptionError(String decryptionError);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private Instant createdAt;

        private String createdBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private JobTemplateData jobTemplateData;

        private String kmsKeyArn;

        private String decryptionError;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplate model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            tags(model.tags);
            jobTemplateData(model.jobTemplateData);
            kmsKeyArn(model.kmsKeyArn);
            decryptionError(model.decryptionError);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final JobTemplateData.Builder getJobTemplateData() {
            return jobTemplateData != null ? jobTemplateData.toBuilder() : null;
        }

        public final void setJobTemplateData(JobTemplateData.BuilderImpl jobTemplateData) {
            this.jobTemplateData = jobTemplateData != null ? jobTemplateData.build() : null;
        }

        @Override
        public final Builder jobTemplateData(JobTemplateData jobTemplateData) {
            this.jobTemplateData = jobTemplateData;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getDecryptionError() {
            return decryptionError;
        }

        public final void setDecryptionError(String decryptionError) {
            this.decryptionError = decryptionError;
        }

        @Override
        public final Builder decryptionError(String decryptionError) {
            this.decryptionError = decryptionError;
            return this;
        }

        @Override
        public JobTemplate build() {
            return new JobTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
