/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entity that provides configuration control over managed logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedLogs implements SdkPojo, Serializable, ToCopyableBuilder<ManagedLogs.Builder, ManagedLogs> {
    private static final SdkField<String> ALLOW_AWS_TO_RETAIN_LOGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allowAWSToRetainLogs").getter(getter(ManagedLogs::allowAWSToRetainLogsAsString))
            .setter(setter(Builder::allowAWSToRetainLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowAWSToRetainLogs").build())
            .build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKeyArn").getter(getter(ManagedLogs::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_AWS_TO_RETAIN_LOGS_FIELD, ENCRYPTION_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String allowAWSToRetainLogs;

    private final String encryptionKeyArn;

    private ManagedLogs(BuilderImpl builder) {
        this.allowAWSToRetainLogs = builder.allowAWSToRetainLogs;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    /**
     * <p>
     * Determines whether Amazon Web Services can retain logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowAWSToRetainLogs} will return {@link AllowAWSToRetainLogs#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allowAWSToRetainLogsAsString}.
     * </p>
     * 
     * @return Determines whether Amazon Web Services can retain logs.
     * @see AllowAWSToRetainLogs
     */
    public final AllowAWSToRetainLogs allowAWSToRetainLogs() {
        return AllowAWSToRetainLogs.fromValue(allowAWSToRetainLogs);
    }

    /**
     * <p>
     * Determines whether Amazon Web Services can retain logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowAWSToRetainLogs} will return {@link AllowAWSToRetainLogs#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allowAWSToRetainLogsAsString}.
     * </p>
     * 
     * @return Determines whether Amazon Web Services can retain logs.
     * @see AllowAWSToRetainLogs
     */
    public final String allowAWSToRetainLogsAsString() {
        return allowAWSToRetainLogs;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the encryption key for logs.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the encryption key for logs.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowAWSToRetainLogsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedLogs)) {
            return false;
        }
        ManagedLogs other = (ManagedLogs) obj;
        return Objects.equals(allowAWSToRetainLogsAsString(), other.allowAWSToRetainLogsAsString())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedLogs").add("AllowAWSToRetainLogs", allowAWSToRetainLogsAsString())
                .add("EncryptionKeyArn", encryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowAWSToRetainLogs":
            return Optional.ofNullable(clazz.cast(allowAWSToRetainLogsAsString()));
        case "encryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowAWSToRetainLogs", ALLOW_AWS_TO_RETAIN_LOGS_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedLogs, T> g) {
        return obj -> g.apply((ManagedLogs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedLogs> {
        /**
         * <p>
         * Determines whether Amazon Web Services can retain logs.
         * </p>
         * 
         * @param allowAWSToRetainLogs
         *        Determines whether Amazon Web Services can retain logs.
         * @see AllowAWSToRetainLogs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowAWSToRetainLogs
         */
        Builder allowAWSToRetainLogs(String allowAWSToRetainLogs);

        /**
         * <p>
         * Determines whether Amazon Web Services can retain logs.
         * </p>
         * 
         * @param allowAWSToRetainLogs
         *        Determines whether Amazon Web Services can retain logs.
         * @see AllowAWSToRetainLogs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowAWSToRetainLogs
         */
        Builder allowAWSToRetainLogs(AllowAWSToRetainLogs allowAWSToRetainLogs);

        /**
         * <p>
         * The Amazon resource name (ARN) of the encryption key for logs.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon resource name (ARN) of the encryption key for logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String allowAWSToRetainLogs;

        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedLogs model) {
            allowAWSToRetainLogs(model.allowAWSToRetainLogs);
            encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getAllowAWSToRetainLogs() {
            return allowAWSToRetainLogs;
        }

        public final void setAllowAWSToRetainLogs(String allowAWSToRetainLogs) {
            this.allowAWSToRetainLogs = allowAWSToRetainLogs;
        }

        @Override
        public final Builder allowAWSToRetainLogs(String allowAWSToRetainLogs) {
            this.allowAWSToRetainLogs = allowAWSToRetainLogs;
            return this;
        }

        @Override
        public final Builder allowAWSToRetainLogs(AllowAWSToRetainLogs allowAWSToRetainLogs) {
            this.allowAWSToRetainLogs(allowAWSToRetainLogs == null ? null : allowAWSToRetainLogs.toString());
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        @Override
        public ManagedLogs build() {
            return new ManagedLogs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
