/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job driver for job type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkSqlJobDriver implements SdkPojo, Serializable,
        ToCopyableBuilder<SparkSqlJobDriver.Builder, SparkSqlJobDriver> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryPoint").getter(getter(SparkSqlJobDriver::entryPoint)).setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()).build();

    private static final SdkField<String> SPARK_SQL_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sparkSqlParameters").getter(getter(SparkSqlJobDriver::sparkSqlParameters))
            .setter(setter(Builder::sparkSqlParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSqlParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD,
            SPARK_SQL_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryPoint;

    private final String sparkSqlParameters;

    private SparkSqlJobDriver(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.sparkSqlParameters = builder.sparkSqlParameters;
    }

    /**
     * <p>
     * The SQL file to be executed.
     * </p>
     * 
     * @return The SQL file to be executed.
     */
    public final String entryPoint() {
        return entryPoint;
    }

    /**
     * <p>
     * The Spark parameters to be included in the Spark SQL command.
     * </p>
     * 
     * @return The Spark parameters to be included in the Spark SQL command.
     */
    public final String sparkSqlParameters() {
        return sparkSqlParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(sparkSqlParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSqlJobDriver)) {
            return false;
        }
        SparkSqlJobDriver other = (SparkSqlJobDriver) obj;
        return Objects.equals(entryPoint(), other.entryPoint())
                && Objects.equals(sparkSqlParameters(), other.sparkSqlParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparkSqlJobDriver")
                .add("EntryPoint", entryPoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SparkSqlParameters", sparkSqlParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "sparkSqlParameters":
            return Optional.ofNullable(clazz.cast(sparkSqlParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("sparkSqlParameters", SPARK_SQL_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkSqlJobDriver, T> g) {
        return obj -> g.apply((SparkSqlJobDriver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkSqlJobDriver> {
        /**
         * <p>
         * The SQL file to be executed.
         * </p>
         * 
         * @param entryPoint
         *        The SQL file to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String entryPoint);

        /**
         * <p>
         * The Spark parameters to be included in the Spark SQL command.
         * </p>
         * 
         * @param sparkSqlParameters
         *        The Spark parameters to be included in the Spark SQL command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSqlParameters(String sparkSqlParameters);
    }

    static final class BuilderImpl implements Builder {
        private String entryPoint;

        private String sparkSqlParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSqlJobDriver model) {
            entryPoint(model.entryPoint);
            sparkSqlParameters(model.sparkSqlParameters);
        }

        public final String getEntryPoint() {
            return entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final String getSparkSqlParameters() {
            return sparkSqlParameters;
        }

        public final void setSparkSqlParameters(String sparkSqlParameters) {
            this.sparkSqlParameters = sparkSqlParameters;
        }

        @Override
        public final Builder sparkSqlParameters(String sparkSqlParameters) {
            this.sparkSqlParameters = sparkSqlParameters;
            return this;
        }

        @Override
        public SparkSqlJobDriver build() {
            return new SparkSqlJobDriver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
