/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends EmrServerlessRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(CreateApplicationRequest::releaseLabel))
            .setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateApplicationRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, InitialCapacityConfig>> INITIAL_CAPACITY_FIELD = SdkField
            .<Map<String, InitialCapacityConfig>> builder(MarshallingType.MAP)
            .memberName("initialCapacity")
            .getter(getter(CreateApplicationRequest::initialCapacity))
            .setter(setter(Builder::initialCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCapacity").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<InitialCapacityConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InitialCapacityConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MaximumAllowedResources> MAXIMUM_CAPACITY_FIELD = SdkField
            .<MaximumAllowedResources> builder(MarshallingType.SDK_POJO).memberName("maximumCapacity")
            .getter(getter(CreateApplicationRequest::maximumCapacity)).setter(setter(Builder::maximumCapacity))
            .constructor(MaximumAllowedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCapacity").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AutoStartConfig> AUTO_START_CONFIGURATION_FIELD = SdkField
            .<AutoStartConfig> builder(MarshallingType.SDK_POJO).memberName("autoStartConfiguration")
            .getter(getter(CreateApplicationRequest::autoStartConfiguration)).setter(setter(Builder::autoStartConfiguration))
            .constructor(AutoStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStartConfiguration").build())
            .build();

    private static final SdkField<AutoStopConfig> AUTO_STOP_CONFIGURATION_FIELD = SdkField
            .<AutoStopConfig> builder(MarshallingType.SDK_POJO).memberName("autoStopConfiguration")
            .getter(getter(CreateApplicationRequest::autoStopConfiguration)).setter(setter(Builder::autoStopConfiguration))
            .constructor(AutoStopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStopConfiguration").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(CreateApplicationRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(CreateApplicationRequest::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<ImageConfigurationInput> IMAGE_CONFIGURATION_FIELD = SdkField
            .<ImageConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("imageConfiguration")
            .getter(getter(CreateApplicationRequest::imageConfiguration)).setter(setter(Builder::imageConfiguration))
            .constructor(ImageConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageConfiguration").build())
            .build();

    private static final SdkField<Map<String, WorkerTypeSpecificationInput>> WORKER_TYPE_SPECIFICATIONS_FIELD = SdkField
            .<Map<String, WorkerTypeSpecificationInput>> builder(MarshallingType.MAP)
            .memberName("workerTypeSpecifications")
            .getter(getter(CreateApplicationRequest::workerTypeSpecifications))
            .setter(setter(Builder::workerTypeSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerTypeSpecifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkerTypeSpecificationInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerTypeSpecificationInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RELEASE_LABEL_FIELD, TYPE_FIELD, CLIENT_TOKEN_FIELD, INITIAL_CAPACITY_FIELD, MAXIMUM_CAPACITY_FIELD, TAGS_FIELD,
            AUTO_START_CONFIGURATION_FIELD, AUTO_STOP_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, ARCHITECTURE_FIELD,
            IMAGE_CONFIGURATION_FIELD, WORKER_TYPE_SPECIFICATIONS_FIELD));

    private final String name;

    private final String releaseLabel;

    private final String type;

    private final String clientToken;

    private final Map<String, InitialCapacityConfig> initialCapacity;

    private final MaximumAllowedResources maximumCapacity;

    private final Map<String, String> tags;

    private final AutoStartConfig autoStartConfiguration;

    private final AutoStopConfig autoStopConfiguration;

    private final NetworkConfiguration networkConfiguration;

    private final String architecture;

    private final ImageConfigurationInput imageConfiguration;

    private final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.clientToken = builder.clientToken;
        this.initialCapacity = builder.initialCapacity;
        this.maximumCapacity = builder.maximumCapacity;
        this.tags = builder.tags;
        this.autoStartConfiguration = builder.autoStartConfiguration;
        this.autoStopConfiguration = builder.autoStopConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.architecture = builder.architecture;
        this.imageConfiguration = builder.imageConfiguration;
        this.workerTypeSpecifications = builder.workerTypeSpecifications;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The EMR release associated with the application.
     * </p>
     * 
     * @return The EMR release associated with the application.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The type of application you want to start, such as Spark or Hive.
     * </p>
     * 
     * @return The type of application you want to start, such as Spark or Hive.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The client idempotency token of the application to create. Its value must be unique for each request.
     * </p>
     * 
     * @return The client idempotency token of the application to create. Its value must be unique for each request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitialCapacity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitialCapacity() {
        return initialCapacity != null && !(initialCapacity instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The capacity to initialize when the application is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitialCapacity} method.
     * </p>
     * 
     * @return The capacity to initialize when the application is created.
     */
    public final Map<String, InitialCapacityConfig> initialCapacity() {
        return initialCapacity;
    }

    /**
     * <p>
     * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any
     * given point in time, not just when an application is created. No new resources will be created once any one of
     * the defined limits is hit.
     * </p>
     * 
     * @return The maximum capacity to allocate when the application is created. This is cumulative across all workers
     *         at any given point in time, not just when an application is created. No new resources will be created
     *         once any one of the defined limits is hit.
     */
    public final MaximumAllowedResources maximumCapacity() {
        return maximumCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for an application to automatically start on job submission.
     * </p>
     * 
     * @return The configuration for an application to automatically start on job submission.
     */
    public final AutoStartConfig autoStartConfiguration() {
        return autoStartConfiguration;
    }

    /**
     * <p>
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * </p>
     * 
     * @return The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public final AutoStopConfig autoStopConfiguration() {
        return autoStopConfiguration;
    }

    /**
     * <p>
     * The network configuration for customer VPC connectivity.
     * </p>
     * 
     * @return The network configuration for customer VPC connectivity.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The image configuration for all worker types. You can either set this parameter or
     * <code>imageConfiguration</code> for each worker type in <code>workerTypeSpecifications</code>.
     * </p>
     * 
     * @return The image configuration for all worker types. You can either set this parameter or
     *         <code>imageConfiguration</code> for each worker type in <code>workerTypeSpecifications</code>.
     */
    public final ImageConfigurationInput imageConfiguration() {
        return imageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkerTypeSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkerTypeSpecifications() {
        return workerTypeSpecifications != null && !(workerTypeSpecifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter must
     * contain all valid worker types for a Spark or Hive application. Valid worker types include <code>Driver</code>
     * and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and <code>TezTask</code> for Hive
     * applications. You can either set image details in this parameter for each worker type, or in
     * <code>imageConfiguration</code> for all worker types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkerTypeSpecifications} method.
     * </p>
     * 
     * @return The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter
     *         must contain all valid worker types for a Spark or Hive application. Valid worker types include
     *         <code>Driver</code> and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and
     *         <code>TezTask</code> for Hive applications. You can either set image details in this parameter for each
     *         worker type, or in <code>imageConfiguration</code> for all worker types.
     */
    public final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications() {
        return workerTypeSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInitialCapacity() ? initialCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoStartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoStopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(releaseLabel(), other.releaseLabel())
                && Objects.equals(type(), other.type()) && Objects.equals(clientToken(), other.clientToken())
                && hasInitialCapacity() == other.hasInitialCapacity()
                && Objects.equals(initialCapacity(), other.initialCapacity())
                && Objects.equals(maximumCapacity(), other.maximumCapacity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(autoStartConfiguration(), other.autoStartConfiguration())
                && Objects.equals(autoStopConfiguration(), other.autoStopConfiguration())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(imageConfiguration(), other.imageConfiguration())
                && hasWorkerTypeSpecifications() == other.hasWorkerTypeSpecifications()
                && Objects.equals(workerTypeSpecifications(), other.workerTypeSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("Name", name()).add("ReleaseLabel", releaseLabel())
                .add("Type", type()).add("ClientToken", clientToken())
                .add("InitialCapacity", hasInitialCapacity() ? initialCapacity() : null)
                .add("MaximumCapacity", maximumCapacity()).add("Tags", hasTags() ? tags() : null)
                .add("AutoStartConfiguration", autoStartConfiguration()).add("AutoStopConfiguration", autoStopConfiguration())
                .add("NetworkConfiguration", networkConfiguration()).add("Architecture", architectureAsString())
                .add("ImageConfiguration", imageConfiguration())
                .add("WorkerTypeSpecifications", hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "initialCapacity":
            return Optional.ofNullable(clazz.cast(initialCapacity()));
        case "maximumCapacity":
            return Optional.ofNullable(clazz.cast(maximumCapacity()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "autoStartConfiguration":
            return Optional.ofNullable(clazz.cast(autoStartConfiguration()));
        case "autoStopConfiguration":
            return Optional.ofNullable(clazz.cast(autoStopConfiguration()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "imageConfiguration":
            return Optional.ofNullable(clazz.cast(imageConfiguration()));
        case "workerTypeSpecifications":
            return Optional.ofNullable(clazz.cast(workerTypeSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The EMR release associated with the application.
         * </p>
         * 
         * @param releaseLabel
         *        The EMR release associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The type of application you want to start, such as Spark or Hive.
         * </p>
         * 
         * @param type
         *        The type of application you want to start, such as Spark or Hive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The client idempotency token of the application to create. Its value must be unique for each request.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token of the application to create. Its value must be unique for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The capacity to initialize when the application is created.
         * </p>
         * 
         * @param initialCapacity
         *        The capacity to initialize when the application is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity);

        /**
         * <p>
         * The maximum capacity to allocate when the application is created. This is cumulative across all workers at
         * any given point in time, not just when an application is created. No new resources will be created once any
         * one of the defined limits is hit.
         * </p>
         * 
         * @param maximumCapacity
         *        The maximum capacity to allocate when the application is created. This is cumulative across all
         *        workers at any given point in time, not just when an application is created. No new resources will be
         *        created once any one of the defined limits is hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumCapacity(MaximumAllowedResources maximumCapacity);

        /**
         * <p>
         * The maximum capacity to allocate when the application is created. This is cumulative across all workers at
         * any given point in time, not just when an application is created. No new resources will be created once any
         * one of the defined limits is hit.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaximumAllowedResources.Builder} avoiding
         * the need to create one manually via {@link MaximumAllowedResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaximumAllowedResources.Builder#build()} is called immediately
         * and its result is passed to {@link #maximumCapacity(MaximumAllowedResources)}.
         * 
         * @param maximumCapacity
         *        a consumer that will call methods on {@link MaximumAllowedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumCapacity(MaximumAllowedResources)
         */
        default Builder maximumCapacity(Consumer<MaximumAllowedResources.Builder> maximumCapacity) {
            return maximumCapacity(MaximumAllowedResources.builder().applyMutation(maximumCapacity).build());
        }

        /**
         * <p>
         * The tags assigned to the application.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * 
         * @param autoStartConfiguration
         *        The configuration for an application to automatically start on job submission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStartConfig.Builder} avoiding the
         * need to create one manually via {@link AutoStartConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStartConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStartConfiguration(AutoStartConfig)}.
         * 
         * @param autoStartConfiguration
         *        a consumer that will call methods on {@link AutoStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStartConfiguration(AutoStartConfig)
         */
        default Builder autoStartConfiguration(Consumer<AutoStartConfig.Builder> autoStartConfiguration) {
            return autoStartConfiguration(AutoStartConfig.builder().applyMutation(autoStartConfiguration).build());
        }

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * 
         * @param autoStopConfiguration
         *        The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStopConfig.Builder} avoiding the need
         * to create one manually via {@link AutoStopConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStopConfiguration(AutoStopConfig)}.
         * 
         * @param autoStopConfiguration
         *        a consumer that will call methods on {@link AutoStopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStopConfiguration(AutoStopConfig)
         */
        default Builder autoStopConfiguration(Consumer<AutoStopConfig.Builder> autoStopConfiguration) {
            return autoStopConfiguration(AutoStopConfig.builder().applyMutation(autoStopConfiguration).build());
        }

        /**
         * <p>
         * The network configuration for customer VPC connectivity.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for customer VPC connectivity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for customer VPC connectivity.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The image configuration for all worker types. You can either set this parameter or
         * <code>imageConfiguration</code> for each worker type in <code>workerTypeSpecifications</code>.
         * </p>
         * 
         * @param imageConfiguration
         *        The image configuration for all worker types. You can either set this parameter or
         *        <code>imageConfiguration</code> for each worker type in <code>workerTypeSpecifications</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfiguration(ImageConfigurationInput imageConfiguration);

        /**
         * <p>
         * The image configuration for all worker types. You can either set this parameter or
         * <code>imageConfiguration</code> for each worker type in <code>workerTypeSpecifications</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfigurationInput.Builder} avoiding
         * the need to create one manually via {@link ImageConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfigurationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #imageConfiguration(ImageConfigurationInput)}.
         * 
         * @param imageConfiguration
         *        a consumer that will call methods on {@link ImageConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfiguration(ImageConfigurationInput)
         */
        default Builder imageConfiguration(Consumer<ImageConfigurationInput.Builder> imageConfiguration) {
            return imageConfiguration(ImageConfigurationInput.builder().applyMutation(imageConfiguration).build());
        }

        /**
         * <p>
         * The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter
         * must contain all valid worker types for a Spark or Hive application. Valid worker types include
         * <code>Driver</code> and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and
         * <code>TezTask</code> for Hive applications. You can either set image details in this parameter for each
         * worker type, or in <code>imageConfiguration</code> for all worker types.
         * </p>
         * 
         * @param workerTypeSpecifications
         *        The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This
         *        parameter must contain all valid worker types for a Spark or Hive application. Valid worker types
         *        include <code>Driver</code> and <code>Executor</code> for Spark applications and
         *        <code>HiveDriver</code> and <code>TezTask</code> for Hive applications. You can either set image
         *        details in this parameter for each worker type, or in <code>imageConfiguration</code> for all worker
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrServerlessRequest.BuilderImpl implements Builder {
        private String name;

        private String releaseLabel;

        private String type;

        private String clientToken;

        private Map<String, InitialCapacityConfig> initialCapacity = DefaultSdkAutoConstructMap.getInstance();

        private MaximumAllowedResources maximumCapacity;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private AutoStartConfig autoStartConfiguration;

        private AutoStopConfig autoStopConfiguration;

        private NetworkConfiguration networkConfiguration;

        private String architecture;

        private ImageConfigurationInput imageConfiguration;

        private Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            name(model.name);
            releaseLabel(model.releaseLabel);
            type(model.type);
            clientToken(model.clientToken);
            initialCapacity(model.initialCapacity);
            maximumCapacity(model.maximumCapacity);
            tags(model.tags);
            autoStartConfiguration(model.autoStartConfiguration);
            autoStopConfiguration(model.autoStopConfiguration);
            networkConfiguration(model.networkConfiguration);
            architecture(model.architecture);
            imageConfiguration(model.imageConfiguration);
            workerTypeSpecifications(model.workerTypeSpecifications);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, InitialCapacityConfig.Builder> getInitialCapacity() {
            Map<String, InitialCapacityConfig.Builder> result = InitialCapacityConfigMapCopier
                    .copyToBuilder(this.initialCapacity);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInitialCapacity(Map<String, InitialCapacityConfig.BuilderImpl> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copyFromBuilder(initialCapacity);
        }

        @Override
        public final Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copy(initialCapacity);
            return this;
        }

        public final MaximumAllowedResources.Builder getMaximumCapacity() {
            return maximumCapacity != null ? maximumCapacity.toBuilder() : null;
        }

        public final void setMaximumCapacity(MaximumAllowedResources.BuilderImpl maximumCapacity) {
            this.maximumCapacity = maximumCapacity != null ? maximumCapacity.build() : null;
        }

        @Override
        public final Builder maximumCapacity(MaximumAllowedResources maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final AutoStartConfig.Builder getAutoStartConfiguration() {
            return autoStartConfiguration != null ? autoStartConfiguration.toBuilder() : null;
        }

        public final void setAutoStartConfiguration(AutoStartConfig.BuilderImpl autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration != null ? autoStartConfiguration.build() : null;
        }

        @Override
        public final Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        public final AutoStopConfig.Builder getAutoStopConfiguration() {
            return autoStopConfiguration != null ? autoStopConfiguration.toBuilder() : null;
        }

        public final void setAutoStopConfiguration(AutoStopConfig.BuilderImpl autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration != null ? autoStopConfiguration.build() : null;
        }

        @Override
        public final Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final ImageConfigurationInput.Builder getImageConfiguration() {
            return imageConfiguration != null ? imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfigurationInput.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfigurationInput imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public final Map<String, WorkerTypeSpecificationInput.Builder> getWorkerTypeSpecifications() {
            Map<String, WorkerTypeSpecificationInput.Builder> result = WorkerTypeSpecificationInputMapCopier
                    .copyToBuilder(this.workerTypeSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkerTypeSpecifications(
                Map<String, WorkerTypeSpecificationInput.BuilderImpl> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copyFromBuilder(workerTypeSpecifications);
        }

        @Override
        public final Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copy(workerTypeSpecifications);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
