/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The applied image configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageConfiguration.Builder, ImageConfiguration> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageUri").getter(getter(ImageConfiguration::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUri").build()).build();

    private static final SdkField<String> RESOLVED_IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolvedImageDigest").getter(getter(ImageConfiguration::resolvedImageDigest))
            .setter(setter(Builder::resolvedImageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedImageDigest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD,
            RESOLVED_IMAGE_DIGEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageUri;

    private final String resolvedImageDigest;

    private ImageConfiguration(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.resolvedImageDigest = builder.resolvedImageDigest;
    }

    /**
     * <p>
     * The image URI.
     * </p>
     * 
     * @return The image URI.
     */
    public final String imageUri() {
        return imageUri;
    }

    /**
     * <p>
     * The SHA256 digest of the image URI. This indicates which specific image the application is configured for. The
     * image digest doesn't exist until an application has started.
     * </p>
     * 
     * @return The SHA256 digest of the image URI. This indicates which specific image the application is configured
     *         for. The image digest doesn't exist until an application has started.
     */
    public final String resolvedImageDigest() {
        return resolvedImageDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedImageDigest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration) obj;
        return Objects.equals(imageUri(), other.imageUri()) && Objects.equals(resolvedImageDigest(), other.resolvedImageDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageConfiguration").add("ImageUri", imageUri())
                .add("ResolvedImageDigest", resolvedImageDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        case "resolvedImageDigest":
            return Optional.ofNullable(clazz.cast(resolvedImageDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfiguration, T> g) {
        return obj -> g.apply((ImageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageConfiguration> {
        /**
         * <p>
         * The image URI.
         * </p>
         * 
         * @param imageUri
         *        The image URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);

        /**
         * <p>
         * The SHA256 digest of the image URI. This indicates which specific image the application is configured for.
         * The image digest doesn't exist until an application has started.
         * </p>
         * 
         * @param resolvedImageDigest
         *        The SHA256 digest of the image URI. This indicates which specific image the application is configured
         *        for. The image digest doesn't exist until an application has started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedImageDigest(String resolvedImageDigest);
    }

    static final class BuilderImpl implements Builder {
        private String imageUri;

        private String resolvedImageDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfiguration model) {
            imageUri(model.imageUri);
            resolvedImageDigest(model.resolvedImageDigest);
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final String getResolvedImageDigest() {
            return resolvedImageDigest;
        }

        public final void setResolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
        }

        @Override
        public final Builder resolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
            return this;
        }

        @Override
        public ImageConfiguration build() {
            return new ImageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
