/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends EmrServerlessRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateApplicationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, InitialCapacityConfig>> INITIAL_CAPACITY_FIELD = SdkField
            .<Map<String, InitialCapacityConfig>> builder(MarshallingType.MAP)
            .memberName("initialCapacity")
            .getter(getter(UpdateApplicationRequest::initialCapacity))
            .setter(setter(Builder::initialCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCapacity").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<InitialCapacityConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InitialCapacityConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MaximumAllowedResources> MAXIMUM_CAPACITY_FIELD = SdkField
            .<MaximumAllowedResources> builder(MarshallingType.SDK_POJO).memberName("maximumCapacity")
            .getter(getter(UpdateApplicationRequest::maximumCapacity)).setter(setter(Builder::maximumCapacity))
            .constructor(MaximumAllowedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCapacity").build()).build();

    private static final SdkField<AutoStartConfig> AUTO_START_CONFIGURATION_FIELD = SdkField
            .<AutoStartConfig> builder(MarshallingType.SDK_POJO).memberName("autoStartConfiguration")
            .getter(getter(UpdateApplicationRequest::autoStartConfiguration)).setter(setter(Builder::autoStartConfiguration))
            .constructor(AutoStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStartConfiguration").build())
            .build();

    private static final SdkField<AutoStopConfig> AUTO_STOP_CONFIGURATION_FIELD = SdkField
            .<AutoStopConfig> builder(MarshallingType.SDK_POJO).memberName("autoStopConfiguration")
            .getter(getter(UpdateApplicationRequest::autoStopConfiguration)).setter(setter(Builder::autoStopConfiguration))
            .constructor(AutoStopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStopConfiguration").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(UpdateApplicationRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(UpdateApplicationRequest::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<ImageConfigurationInput> IMAGE_CONFIGURATION_FIELD = SdkField
            .<ImageConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("imageConfiguration")
            .getter(getter(UpdateApplicationRequest::imageConfiguration)).setter(setter(Builder::imageConfiguration))
            .constructor(ImageConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageConfiguration").build())
            .build();

    private static final SdkField<Map<String, WorkerTypeSpecificationInput>> WORKER_TYPE_SPECIFICATIONS_FIELD = SdkField
            .<Map<String, WorkerTypeSpecificationInput>> builder(MarshallingType.MAP)
            .memberName("workerTypeSpecifications")
            .getter(getter(UpdateApplicationRequest::workerTypeSpecifications))
            .setter(setter(Builder::workerTypeSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerTypeSpecifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkerTypeSpecificationInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerTypeSpecificationInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(UpdateApplicationRequest::releaseLabel))
            .setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<List<Configuration>> RUNTIME_CONFIGURATION_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("runtimeConfiguration")
            .getter(getter(UpdateApplicationRequest::runtimeConfiguration))
            .setter(setter(Builder::runtimeConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("monitoringConfiguration")
            .getter(getter(UpdateApplicationRequest::monitoringConfiguration)).setter(setter(Builder::monitoringConfiguration))
            .constructor(MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CLIENT_TOKEN_FIELD, INITIAL_CAPACITY_FIELD, MAXIMUM_CAPACITY_FIELD, AUTO_START_CONFIGURATION_FIELD,
            AUTO_STOP_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, ARCHITECTURE_FIELD, IMAGE_CONFIGURATION_FIELD,
            WORKER_TYPE_SPECIFICATIONS_FIELD, RELEASE_LABEL_FIELD, RUNTIME_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD));

    private final String applicationId;

    private final String clientToken;

    private final Map<String, InitialCapacityConfig> initialCapacity;

    private final MaximumAllowedResources maximumCapacity;

    private final AutoStartConfig autoStartConfiguration;

    private final AutoStopConfig autoStopConfiguration;

    private final NetworkConfiguration networkConfiguration;

    private final String architecture;

    private final ImageConfigurationInput imageConfiguration;

    private final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications;

    private final String releaseLabel;

    private final List<Configuration> runtimeConfiguration;

    private final MonitoringConfiguration monitoringConfiguration;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.initialCapacity = builder.initialCapacity;
        this.maximumCapacity = builder.maximumCapacity;
        this.autoStartConfiguration = builder.autoStartConfiguration;
        this.autoStopConfiguration = builder.autoStopConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.architecture = builder.architecture;
        this.imageConfiguration = builder.imageConfiguration;
        this.workerTypeSpecifications = builder.workerTypeSpecifications;
        this.releaseLabel = builder.releaseLabel;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
    }

    /**
     * <p>
     * The ID of the application to update.
     * </p>
     * 
     * @return The ID of the application to update.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The client idempotency token of the application to update. Its value must be unique for each request.
     * </p>
     * 
     * @return The client idempotency token of the application to update. Its value must be unique for each request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitialCapacity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitialCapacity() {
        return initialCapacity != null && !(initialCapacity instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The capacity to initialize when the application is updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitialCapacity} method.
     * </p>
     * 
     * @return The capacity to initialize when the application is updated.
     */
    public final Map<String, InitialCapacityConfig> initialCapacity() {
        return initialCapacity;
    }

    /**
     * <p>
     * The maximum capacity to allocate when the application is updated. This is cumulative across all workers at any
     * given point in time during the lifespan of the application. No new resources will be created once any one of the
     * defined limits is hit.
     * </p>
     * 
     * @return The maximum capacity to allocate when the application is updated. This is cumulative across all workers
     *         at any given point in time during the lifespan of the application. No new resources will be created once
     *         any one of the defined limits is hit.
     */
    public final MaximumAllowedResources maximumCapacity() {
        return maximumCapacity;
    }

    /**
     * <p>
     * The configuration for an application to automatically start on job submission.
     * </p>
     * 
     * @return The configuration for an application to automatically start on job submission.
     */
    public final AutoStartConfig autoStartConfiguration() {
        return autoStartConfiguration;
    }

    /**
     * <p>
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * </p>
     * 
     * @return The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public final AutoStopConfig autoStopConfiguration() {
        return autoStopConfiguration;
    }

    /**
     * Returns the value of the NetworkConfiguration property for this object.
     * 
     * @return The value of the NetworkConfiguration property for this object.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The CPU architecture of an application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The CPU architecture of an application.
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The image configuration to be used for all worker types. You can either set this parameter or
     * <code>imageConfiguration</code> for each worker type in <code>WorkerTypeSpecificationInput</code>.
     * </p>
     * 
     * @return The image configuration to be used for all worker types. You can either set this parameter or
     *         <code>imageConfiguration</code> for each worker type in <code>WorkerTypeSpecificationInput</code>.
     */
    public final ImageConfigurationInput imageConfiguration() {
        return imageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkerTypeSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkerTypeSpecifications() {
        return workerTypeSpecifications != null && !(workerTypeSpecifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter must
     * contain all valid worker types for a Spark or Hive application. Valid worker types include <code>Driver</code>
     * and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and <code>TezTask</code> for Hive
     * applications. You can either set image details in this parameter for each worker type, or in
     * <code>imageConfiguration</code> for all worker types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkerTypeSpecifications} method.
     * </p>
     * 
     * @return The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter
     *         must contain all valid worker types for a Spark or Hive application. Valid worker types include
     *         <code>Driver</code> and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and
     *         <code>TezTask</code> for Hive applications. You can either set image details in this parameter for each
     *         worker type, or in <code>imageConfiguration</code> for all worker types.
     */
    public final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications() {
        return workerTypeSpecifications;
    }

    /**
     * <p>
     * The Amazon EMR release label for the application. You can change the release label to use a different release of
     * Amazon EMR.
     * </p>
     * 
     * @return The Amazon EMR release label for the application. You can change the release label to use a different
     *         release of Amazon EMR.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuntimeConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuntimeConfiguration() {
        return runtimeConfiguration != null && !(runtimeConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a>
     * specifications to use when updating an application. Each configuration consists of a classification and
     * properties. This configuration is applied across all the job runs submitted under the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuntimeConfiguration} method.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration
     *         </a> specifications to use when updating an application. Each configuration consists of a classification
     *         and properties. This configuration is applied across all the job runs submitted under the application.
     */
    public final List<Configuration> runtimeConfiguration() {
        return runtimeConfiguration;
    }

    /**
     * <p>
     * The configuration setting for monitoring.
     * </p>
     * 
     * @return The configuration setting for monitoring.
     */
    public final MonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInitialCapacity() ? initialCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(autoStartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoStopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuntimeConfiguration() ? runtimeConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && hasInitialCapacity() == other.hasInitialCapacity()
                && Objects.equals(initialCapacity(), other.initialCapacity())
                && Objects.equals(maximumCapacity(), other.maximumCapacity())
                && Objects.equals(autoStartConfiguration(), other.autoStartConfiguration())
                && Objects.equals(autoStopConfiguration(), other.autoStopConfiguration())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(imageConfiguration(), other.imageConfiguration())
                && hasWorkerTypeSpecifications() == other.hasWorkerTypeSpecifications()
                && Objects.equals(workerTypeSpecifications(), other.workerTypeSpecifications())
                && Objects.equals(releaseLabel(), other.releaseLabel())
                && hasRuntimeConfiguration() == other.hasRuntimeConfiguration()
                && Objects.equals(runtimeConfiguration(), other.runtimeConfiguration())
                && Objects.equals(monitoringConfiguration(), other.monitoringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationId", applicationId())
                .add("ClientToken", clientToken()).add("InitialCapacity", hasInitialCapacity() ? initialCapacity() : null)
                .add("MaximumCapacity", maximumCapacity()).add("AutoStartConfiguration", autoStartConfiguration())
                .add("AutoStopConfiguration", autoStopConfiguration()).add("NetworkConfiguration", networkConfiguration())
                .add("Architecture", architectureAsString()).add("ImageConfiguration", imageConfiguration())
                .add("WorkerTypeSpecifications", hasWorkerTypeSpecifications() ? workerTypeSpecifications() : null)
                .add("ReleaseLabel", releaseLabel())
                .add("RuntimeConfiguration", hasRuntimeConfiguration() ? runtimeConfiguration() : null)
                .add("MonitoringConfiguration", monitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "initialCapacity":
            return Optional.ofNullable(clazz.cast(initialCapacity()));
        case "maximumCapacity":
            return Optional.ofNullable(clazz.cast(maximumCapacity()));
        case "autoStartConfiguration":
            return Optional.ofNullable(clazz.cast(autoStartConfiguration()));
        case "autoStopConfiguration":
            return Optional.ofNullable(clazz.cast(autoStopConfiguration()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "imageConfiguration":
            return Optional.ofNullable(clazz.cast(imageConfiguration()));
        case "workerTypeSpecifications":
            return Optional.ofNullable(clazz.cast(workerTypeSpecifications()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "runtimeConfiguration":
            return Optional.ofNullable(clazz.cast(runtimeConfiguration()));
        case "monitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The ID of the application to update.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The client idempotency token of the application to update. Its value must be unique for each request.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token of the application to update. Its value must be unique for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The capacity to initialize when the application is updated.
         * </p>
         * 
         * @param initialCapacity
         *        The capacity to initialize when the application is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity);

        /**
         * <p>
         * The maximum capacity to allocate when the application is updated. This is cumulative across all workers at
         * any given point in time during the lifespan of the application. No new resources will be created once any one
         * of the defined limits is hit.
         * </p>
         * 
         * @param maximumCapacity
         *        The maximum capacity to allocate when the application is updated. This is cumulative across all
         *        workers at any given point in time during the lifespan of the application. No new resources will be
         *        created once any one of the defined limits is hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumCapacity(MaximumAllowedResources maximumCapacity);

        /**
         * <p>
         * The maximum capacity to allocate when the application is updated. This is cumulative across all workers at
         * any given point in time during the lifespan of the application. No new resources will be created once any one
         * of the defined limits is hit.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaximumAllowedResources.Builder} avoiding
         * the need to create one manually via {@link MaximumAllowedResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaximumAllowedResources.Builder#build()} is called immediately
         * and its result is passed to {@link #maximumCapacity(MaximumAllowedResources)}.
         * 
         * @param maximumCapacity
         *        a consumer that will call methods on {@link MaximumAllowedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumCapacity(MaximumAllowedResources)
         */
        default Builder maximumCapacity(Consumer<MaximumAllowedResources.Builder> maximumCapacity) {
            return maximumCapacity(MaximumAllowedResources.builder().applyMutation(maximumCapacity).build());
        }

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * 
         * @param autoStartConfiguration
         *        The configuration for an application to automatically start on job submission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically start on job submission.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStartConfig.Builder} avoiding the
         * need to create one manually via {@link AutoStartConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStartConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStartConfiguration(AutoStartConfig)}.
         * 
         * @param autoStartConfiguration
         *        a consumer that will call methods on {@link AutoStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStartConfiguration(AutoStartConfig)
         */
        default Builder autoStartConfiguration(Consumer<AutoStartConfig.Builder> autoStartConfiguration) {
            return autoStartConfiguration(AutoStartConfig.builder().applyMutation(autoStartConfiguration).build());
        }

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * 
         * @param autoStopConfiguration
         *        The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration);

        /**
         * <p>
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoStopConfig.Builder} avoiding the need
         * to create one manually via {@link AutoStopConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoStopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoStopConfiguration(AutoStopConfig)}.
         * 
         * @param autoStopConfiguration
         *        a consumer that will call methods on {@link AutoStopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoStopConfiguration(AutoStopConfig)
         */
        default Builder autoStopConfiguration(Consumer<AutoStopConfig.Builder> autoStopConfiguration) {
            return autoStopConfiguration(AutoStopConfig.builder().applyMutation(autoStopConfiguration).build());
        }

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * @param networkConfiguration
         *        The new value for the NetworkConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The CPU architecture of an application.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of an application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The image configuration to be used for all worker types. You can either set this parameter or
         * <code>imageConfiguration</code> for each worker type in <code>WorkerTypeSpecificationInput</code>.
         * </p>
         * 
         * @param imageConfiguration
         *        The image configuration to be used for all worker types. You can either set this parameter or
         *        <code>imageConfiguration</code> for each worker type in <code>WorkerTypeSpecificationInput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfiguration(ImageConfigurationInput imageConfiguration);

        /**
         * <p>
         * The image configuration to be used for all worker types. You can either set this parameter or
         * <code>imageConfiguration</code> for each worker type in <code>WorkerTypeSpecificationInput</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfigurationInput.Builder} avoiding
         * the need to create one manually via {@link ImageConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfigurationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #imageConfiguration(ImageConfigurationInput)}.
         * 
         * @param imageConfiguration
         *        a consumer that will call methods on {@link ImageConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfiguration(ImageConfigurationInput)
         */
        default Builder imageConfiguration(Consumer<ImageConfigurationInput.Builder> imageConfiguration) {
            return imageConfiguration(ImageConfigurationInput.builder().applyMutation(imageConfiguration).build());
        }

        /**
         * <p>
         * The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This parameter
         * must contain all valid worker types for a Spark or Hive application. Valid worker types include
         * <code>Driver</code> and <code>Executor</code> for Spark applications and <code>HiveDriver</code> and
         * <code>TezTask</code> for Hive applications. You can either set image details in this parameter for each
         * worker type, or in <code>imageConfiguration</code> for all worker types.
         * </p>
         * 
         * @param workerTypeSpecifications
         *        The key-value pairs that specify worker type to <code>WorkerTypeSpecificationInput</code>. This
         *        parameter must contain all valid worker types for a Spark or Hive application. Valid worker types
         *        include <code>Driver</code> and <code>Executor</code> for Spark applications and
         *        <code>HiveDriver</code> and <code>TezTask</code> for Hive applications. You can either set image
         *        details in this parameter for each worker type, or in <code>imageConfiguration</code> for all worker
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications);

        /**
         * <p>
         * The Amazon EMR release label for the application. You can change the release label to use a different release
         * of Amazon EMR.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release label for the application. You can change the release label to use a different
         *        release of Amazon EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The <a
         * href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration
         * </a> specifications to use when updating an application. Each configuration consists of a classification and
         * properties. This configuration is applied across all the job runs submitted under the application.
         * </p>
         * 
         * @param runtimeConfiguration
         *        The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">
         *        Configuration</a> specifications to use when updating an application. Each configuration consists of a
         *        classification and properties. This configuration is applied across all the job runs submitted under
         *        the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(Collection<Configuration> runtimeConfiguration);

        /**
         * <p>
         * The <a
         * href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration
         * </a> specifications to use when updating an application. Each configuration consists of a classification and
         * properties. This configuration is applied across all the job runs submitted under the application.
         * </p>
         * 
         * @param runtimeConfiguration
         *        The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">
         *        Configuration</a> specifications to use when updating an application. Each configuration consists of a
         *        classification and properties. This configuration is applied across all the job runs submitted under
         *        the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(Configuration... runtimeConfiguration);

        /**
         * <p>
         * The <a
         * href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration
         * </a> specifications to use when updating an application. Each configuration consists of a classification and
         * properties. This configuration is applied across all the job runs submitted under the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emrserverless.model.Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder#build()} is called
         * immediately and its result is passed to {@link #runtimeConfiguration(List<Configuration>)}.
         * 
         * @param runtimeConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfiguration(java.util.Collection<Configuration>)
         */
        Builder runtimeConfiguration(Consumer<Configuration.Builder>... runtimeConfiguration);

        /**
         * <p>
         * The configuration setting for monitoring.
         * </p>
         * 
         * @param monitoringConfiguration
         *        The configuration setting for monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * The configuration setting for monitoring.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfiguration.Builder} avoiding
         * the need to create one manually via {@link MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringConfiguration(MonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(MonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(MonitoringConfiguration.builder().applyMutation(monitoringConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrServerlessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private Map<String, InitialCapacityConfig> initialCapacity = DefaultSdkAutoConstructMap.getInstance();

        private MaximumAllowedResources maximumCapacity;

        private AutoStartConfig autoStartConfiguration;

        private AutoStopConfig autoStopConfiguration;

        private NetworkConfiguration networkConfiguration;

        private String architecture;

        private ImageConfigurationInput imageConfiguration;

        private Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications = DefaultSdkAutoConstructMap.getInstance();

        private String releaseLabel;

        private List<Configuration> runtimeConfiguration = DefaultSdkAutoConstructList.getInstance();

        private MonitoringConfiguration monitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            initialCapacity(model.initialCapacity);
            maximumCapacity(model.maximumCapacity);
            autoStartConfiguration(model.autoStartConfiguration);
            autoStopConfiguration(model.autoStopConfiguration);
            networkConfiguration(model.networkConfiguration);
            architecture(model.architecture);
            imageConfiguration(model.imageConfiguration);
            workerTypeSpecifications(model.workerTypeSpecifications);
            releaseLabel(model.releaseLabel);
            runtimeConfiguration(model.runtimeConfiguration);
            monitoringConfiguration(model.monitoringConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, InitialCapacityConfig.Builder> getInitialCapacity() {
            Map<String, InitialCapacityConfig.Builder> result = InitialCapacityConfigMapCopier
                    .copyToBuilder(this.initialCapacity);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInitialCapacity(Map<String, InitialCapacityConfig.BuilderImpl> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copyFromBuilder(initialCapacity);
        }

        @Override
        public final Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copy(initialCapacity);
            return this;
        }

        public final MaximumAllowedResources.Builder getMaximumCapacity() {
            return maximumCapacity != null ? maximumCapacity.toBuilder() : null;
        }

        public final void setMaximumCapacity(MaximumAllowedResources.BuilderImpl maximumCapacity) {
            this.maximumCapacity = maximumCapacity != null ? maximumCapacity.build() : null;
        }

        @Override
        public final Builder maximumCapacity(MaximumAllowedResources maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        public final AutoStartConfig.Builder getAutoStartConfiguration() {
            return autoStartConfiguration != null ? autoStartConfiguration.toBuilder() : null;
        }

        public final void setAutoStartConfiguration(AutoStartConfig.BuilderImpl autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration != null ? autoStartConfiguration.build() : null;
        }

        @Override
        public final Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        public final AutoStopConfig.Builder getAutoStopConfiguration() {
            return autoStopConfiguration != null ? autoStopConfiguration.toBuilder() : null;
        }

        public final void setAutoStopConfiguration(AutoStopConfig.BuilderImpl autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration != null ? autoStopConfiguration.build() : null;
        }

        @Override
        public final Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final ImageConfigurationInput.Builder getImageConfiguration() {
            return imageConfiguration != null ? imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfigurationInput.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfigurationInput imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public final Map<String, WorkerTypeSpecificationInput.Builder> getWorkerTypeSpecifications() {
            Map<String, WorkerTypeSpecificationInput.Builder> result = WorkerTypeSpecificationInputMapCopier
                    .copyToBuilder(this.workerTypeSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkerTypeSpecifications(
                Map<String, WorkerTypeSpecificationInput.BuilderImpl> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copyFromBuilder(workerTypeSpecifications);
        }

        @Override
        public final Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copy(workerTypeSpecifications);
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final List<Configuration.Builder> getRuntimeConfiguration() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.runtimeConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeConfiguration(Collection<Configuration.BuilderImpl> runtimeConfiguration) {
            this.runtimeConfiguration = ConfigurationListCopier.copyFromBuilder(runtimeConfiguration);
        }

        @Override
        public final Builder runtimeConfiguration(Collection<Configuration> runtimeConfiguration) {
            this.runtimeConfiguration = ConfigurationListCopier.copy(runtimeConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeConfiguration(Configuration... runtimeConfiguration) {
            runtimeConfiguration(Arrays.asList(runtimeConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeConfiguration(Consumer<Configuration.Builder>... runtimeConfiguration) {
            runtimeConfiguration(Stream.of(runtimeConfiguration).map(c -> Configuration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
