/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerResourceConfig> {
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(WorkerResourceConfig.getter(WorkerResourceConfig::cpu)).setter(WorkerResourceConfig.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(WorkerResourceConfig.getter(WorkerResourceConfig::memory)).setter(WorkerResourceConfig.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("disk").getter(WorkerResourceConfig.getter(WorkerResourceConfig::disk)).setter(WorkerResourceConfig.setter(Builder::disk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disk").build()}).build();
    private static final SdkField<String> DISK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskType").getter(WorkerResourceConfig.getter(WorkerResourceConfig::diskType)).setter(WorkerResourceConfig.setter(Builder::diskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_FIELD, MEMORY_FIELD, DISK_FIELD, DISK_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cpu;
    private final String memory;
    private final String disk;
    private final String diskType;

    private WorkerResourceConfig(BuilderImpl builder) {
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.disk = builder.disk;
        this.diskType = builder.diskType;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String memory() {
        return this.memory;
    }

    public final String disk() {
        return this.disk;
    }

    public final String diskType() {
        return this.diskType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.disk());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerResourceConfig)) {
            return false;
        }
        WorkerResourceConfig other = (WorkerResourceConfig)obj;
        return Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.disk(), other.disk()) && Objects.equals(this.diskType(), other.diskType());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerResourceConfig").add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("Disk", (Object)this.disk()).add("DiskType", (Object)this.diskType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "disk": {
                return Optional.ofNullable(clazz.cast(this.disk()));
            }
            case "diskType": {
                return Optional.ofNullable(clazz.cast(this.diskType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerResourceConfig, T> g) {
        return obj -> g.apply((WorkerResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cpu;
        private String memory;
        private String disk;
        private String diskType;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerResourceConfig model) {
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.disk(model.disk);
            this.diskType(model.diskType);
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getDisk() {
            return this.disk;
        }

        public final void setDisk(String disk) {
            this.disk = disk;
        }

        @Override
        public final Builder disk(String disk) {
            this.disk = disk;
            return this;
        }

        public final String getDiskType() {
            return this.diskType;
        }

        public final void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        @Override
        public final Builder diskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        public WorkerResourceConfig build() {
            return new WorkerResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerResourceConfig> {
        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder disk(String var1);

        public Builder diskType(String var1);
    }
}

