/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryPolicy> {
    private static final SdkField<Integer> MAX_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxAttempts").getter(RetryPolicy.getter(RetryPolicy::maxAttempts)).setter(RetryPolicy.setter(Builder::maxAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAttempts").build()}).build();
    private static final SdkField<Integer> MAX_FAILED_ATTEMPTS_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailedAttemptsPerHour").getter(RetryPolicy.getter(RetryPolicy::maxFailedAttemptsPerHour)).setter(RetryPolicy.setter(Builder::maxFailedAttemptsPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedAttemptsPerHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ATTEMPTS_FIELD, MAX_FAILED_ATTEMPTS_PER_HOUR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxAttempts;
    private final Integer maxFailedAttemptsPerHour;

    private RetryPolicy(BuilderImpl builder) {
        this.maxAttempts = builder.maxAttempts;
        this.maxFailedAttemptsPerHour = builder.maxFailedAttemptsPerHour;
    }

    public final Integer maxAttempts() {
        return this.maxAttempts;
    }

    public final Integer maxFailedAttemptsPerHour() {
        return this.maxFailedAttemptsPerHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailedAttemptsPerHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy other = (RetryPolicy)obj;
        return Objects.equals(this.maxAttempts(), other.maxAttempts()) && Objects.equals(this.maxFailedAttemptsPerHour(), other.maxFailedAttemptsPerHour());
    }

    public final String toString() {
        return ToString.builder((String)"RetryPolicy").add("MaxAttempts", (Object)this.maxAttempts()).add("MaxFailedAttemptsPerHour", (Object)this.maxFailedAttemptsPerHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxAttempts": {
                return Optional.ofNullable(clazz.cast(this.maxAttempts()));
            }
            case "maxFailedAttemptsPerHour": {
                return Optional.ofNullable(clazz.cast(this.maxFailedAttemptsPerHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicy, T> g) {
        return obj -> g.apply((RetryPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxAttempts;
        private Integer maxFailedAttemptsPerHour;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicy model) {
            this.maxAttempts(model.maxAttempts);
            this.maxFailedAttemptsPerHour(model.maxFailedAttemptsPerHour);
        }

        public final Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public final void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public final Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public final Integer getMaxFailedAttemptsPerHour() {
            return this.maxFailedAttemptsPerHour;
        }

        public final void setMaxFailedAttemptsPerHour(Integer maxFailedAttemptsPerHour) {
            this.maxFailedAttemptsPerHour = maxFailedAttemptsPerHour;
        }

        @Override
        public final Builder maxFailedAttemptsPerHour(Integer maxFailedAttemptsPerHour) {
            this.maxFailedAttemptsPerHour = maxFailedAttemptsPerHour;
            return this;
        }

        public RetryPolicy build() {
            return new RetryPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryPolicy> {
        public Builder maxAttempts(Integer var1);

        public Builder maxFailedAttemptsPerHour(Integer var1);
    }
}

