/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus for a
 * job run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrometheusMonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PrometheusMonitoringConfiguration.Builder, PrometheusMonitoringConfiguration> {
    private static final SdkField<String> REMOTE_WRITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteWriteUrl").getter(getter(PrometheusMonitoringConfiguration::remoteWriteUrl))
            .setter(setter(Builder::remoteWriteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteWriteUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_WRITE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String remoteWriteUrl;

    private PrometheusMonitoringConfiguration(BuilderImpl builder) {
        this.remoteWriteUrl = builder.remoteWriteUrl;
    }

    /**
     * <p>
     * The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
     * </p>
     * 
     * @return The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public final String remoteWriteUrl() {
        return remoteWriteUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteWriteUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrometheusMonitoringConfiguration)) {
            return false;
        }
        PrometheusMonitoringConfiguration other = (PrometheusMonitoringConfiguration) obj;
        return Objects.equals(remoteWriteUrl(), other.remoteWriteUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrometheusMonitoringConfiguration").add("RemoteWriteUrl", remoteWriteUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteWriteUrl":
            return Optional.ofNullable(clazz.cast(remoteWriteUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrometheusMonitoringConfiguration, T> g) {
        return obj -> g.apply((PrometheusMonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrometheusMonitoringConfiguration> {
        /**
         * <p>
         * The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
         * </p>
         * 
         * @param remoteWriteUrl
         *        The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteWriteUrl(String remoteWriteUrl);
    }

    static final class BuilderImpl implements Builder {
        private String remoteWriteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PrometheusMonitoringConfiguration model) {
            remoteWriteUrl(model.remoteWriteUrl);
        }

        public final String getRemoteWriteUrl() {
            return remoteWriteUrl;
        }

        public final void setRemoteWriteUrl(String remoteWriteUrl) {
            this.remoteWriteUrl = remoteWriteUrl;
        }

        @Override
        public final Builder remoteWriteUrl(String remoteWriteUrl) {
            this.remoteWriteUrl = remoteWriteUrl;
            return this;
        }

        @Override
        public PrometheusMonitoringConfiguration build() {
            return new PrometheusMonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
