/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource utilization for memory, storage, and vCPU for jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceUtilization.Builder, ResourceUtilization> {
    private static final SdkField<Double> VCPU_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("vCPUHour").getter(getter(ResourceUtilization::vcpuHour)).setter(setter(Builder::vcpuHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCPUHour").build()).build();

    private static final SdkField<Double> MEMORY_GB_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("memoryGBHour").getter(getter(ResourceUtilization::memoryGBHour)).setter(setter(Builder::memoryGBHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryGBHour").build()).build();

    private static final SdkField<Double> STORAGE_GB_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("storageGBHour").getter(getter(ResourceUtilization::storageGBHour))
            .setter(setter(Builder::storageGBHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageGBHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VCPU_HOUR_FIELD,
            MEMORY_GB_HOUR_FIELD, STORAGE_GB_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double vcpuHour;

    private final Double memoryGBHour;

    private final Double storageGBHour;

    private ResourceUtilization(BuilderImpl builder) {
        this.vcpuHour = builder.vcpuHour;
        this.memoryGBHour = builder.memoryGBHour;
        this.storageGBHour = builder.storageGBHour;
    }

    /**
     * <p>
     * The aggregated vCPU used per hour from the time the job starts executing until the job is terminated.
     * </p>
     * 
     * @return The aggregated vCPU used per hour from the time the job starts executing until the job is terminated.
     */
    public final Double vcpuHour() {
        return vcpuHour;
    }

    /**
     * <p>
     * The aggregated memory used per hour from the time the job starts executing until the job is terminated.
     * </p>
     * 
     * @return The aggregated memory used per hour from the time the job starts executing until the job is terminated.
     */
    public final Double memoryGBHour() {
        return memoryGBHour;
    }

    /**
     * <p>
     * The aggregated storage used per hour from the time the job starts executing until the job is terminated.
     * </p>
     * 
     * @return The aggregated storage used per hour from the time the job starts executing until the job is terminated.
     */
    public final Double storageGBHour() {
        return storageGBHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vcpuHour());
        hashCode = 31 * hashCode + Objects.hashCode(memoryGBHour());
        hashCode = 31 * hashCode + Objects.hashCode(storageGBHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceUtilization)) {
            return false;
        }
        ResourceUtilization other = (ResourceUtilization) obj;
        return Objects.equals(vcpuHour(), other.vcpuHour()) && Objects.equals(memoryGBHour(), other.memoryGBHour())
                && Objects.equals(storageGBHour(), other.storageGBHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceUtilization").add("VCPUHour", vcpuHour()).add("MemoryGBHour", memoryGBHour())
                .add("StorageGBHour", storageGBHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCPUHour":
            return Optional.ofNullable(clazz.cast(vcpuHour()));
        case "memoryGBHour":
            return Optional.ofNullable(clazz.cast(memoryGBHour()));
        case "storageGBHour":
            return Optional.ofNullable(clazz.cast(storageGBHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceUtilization, T> g) {
        return obj -> g.apply((ResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceUtilization> {
        /**
         * <p>
         * The aggregated vCPU used per hour from the time the job starts executing until the job is terminated.
         * </p>
         * 
         * @param vcpuHour
         *        The aggregated vCPU used per hour from the time the job starts executing until the job is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcpuHour(Double vcpuHour);

        /**
         * <p>
         * The aggregated memory used per hour from the time the job starts executing until the job is terminated.
         * </p>
         * 
         * @param memoryGBHour
         *        The aggregated memory used per hour from the time the job starts executing until the job is
         *        terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryGBHour(Double memoryGBHour);

        /**
         * <p>
         * The aggregated storage used per hour from the time the job starts executing until the job is terminated.
         * </p>
         * 
         * @param storageGBHour
         *        The aggregated storage used per hour from the time the job starts executing until the job is
         *        terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageGBHour(Double storageGBHour);
    }

    static final class BuilderImpl implements Builder {
        private Double vcpuHour;

        private Double memoryGBHour;

        private Double storageGBHour;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceUtilization model) {
            vcpuHour(model.vcpuHour);
            memoryGBHour(model.memoryGBHour);
            storageGBHour(model.storageGBHour);
        }

        public final Double getVcpuHour() {
            return vcpuHour;
        }

        public final void setVcpuHour(Double vcpuHour) {
            this.vcpuHour = vcpuHour;
        }

        @Override
        public final Builder vcpuHour(Double vcpuHour) {
            this.vcpuHour = vcpuHour;
            return this;
        }

        public final Double getMemoryGBHour() {
            return memoryGBHour;
        }

        public final void setMemoryGBHour(Double memoryGBHour) {
            this.memoryGBHour = memoryGBHour;
        }

        @Override
        public final Builder memoryGBHour(Double memoryGBHour) {
            this.memoryGBHour = memoryGBHour;
            return this;
        }

        public final Double getStorageGBHour() {
            return storageGBHour;
        }

        public final void setStorageGBHour(Double storageGBHour) {
            this.storageGBHour = storageGBHour;
        }

        @Override
        public final Builder storageGBHour(Double storageGBHour) {
            this.storageGBHour = storageGBHour;
            return this;
        }

        @Override
        public ResourceUtilization build() {
            return new ResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
