/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scheduler configuration for batch and streaming jobs running on this application. Supported with release labels
 * emr-7.0.0 and above.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchedulerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SchedulerConfiguration.Builder, SchedulerConfiguration> {
    private static final SdkField<Integer> QUEUE_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queueTimeoutMinutes").getter(getter(SchedulerConfiguration::queueTimeoutMinutes))
            .setter(setter(Builder::queueTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueTimeoutMinutes").build())
            .build();

    private static final SdkField<Integer> MAX_CONCURRENT_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrentRuns").getter(getter(SchedulerConfiguration::maxConcurrentRuns))
            .setter(setter(Builder::maxConcurrentRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentRuns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_TIMEOUT_MINUTES_FIELD,
            MAX_CONCURRENT_RUNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer queueTimeoutMinutes;

    private final Integer maxConcurrentRuns;

    private SchedulerConfiguration(BuilderImpl builder) {
        this.queueTimeoutMinutes = builder.queueTimeoutMinutes;
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
    }

    /**
     * <p>
     * The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on your
     * application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
     * </p>
     * 
     * @return The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on
     *         your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
     */
    public final Integer queueTimeoutMinutes() {
        return queueTimeoutMinutes;
    }

    /**
     * <p>
     * The maximum concurrent job runs on this application. If scheduler configuration is enabled on your application,
     * the default value is 15. The valid range is 1 to 1000.
     * </p>
     * 
     * @return The maximum concurrent job runs on this application. If scheduler configuration is enabled on your
     *         application, the default value is 15. The valid range is 1 to 1000.
     */
    public final Integer maxConcurrentRuns() {
        return maxConcurrentRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentRuns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulerConfiguration)) {
            return false;
        }
        SchedulerConfiguration other = (SchedulerConfiguration) obj;
        return Objects.equals(queueTimeoutMinutes(), other.queueTimeoutMinutes())
                && Objects.equals(maxConcurrentRuns(), other.maxConcurrentRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchedulerConfiguration").add("QueueTimeoutMinutes", queueTimeoutMinutes())
                .add("MaxConcurrentRuns", maxConcurrentRuns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(queueTimeoutMinutes()));
        case "maxConcurrentRuns":
            return Optional.ofNullable(clazz.cast(maxConcurrentRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchedulerConfiguration, T> g) {
        return obj -> g.apply((SchedulerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchedulerConfiguration> {
        /**
         * <p>
         * The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on your
         * application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
         * </p>
         * 
         * @param queueTimeoutMinutes
         *        The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on
         *        your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueTimeoutMinutes(Integer queueTimeoutMinutes);

        /**
         * <p>
         * The maximum concurrent job runs on this application. If scheduler configuration is enabled on your
         * application, the default value is 15. The valid range is 1 to 1000.
         * </p>
         * 
         * @param maxConcurrentRuns
         *        The maximum concurrent job runs on this application. If scheduler configuration is enabled on your
         *        application, the default value is 15. The valid range is 1 to 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentRuns(Integer maxConcurrentRuns);
    }

    static final class BuilderImpl implements Builder {
        private Integer queueTimeoutMinutes;

        private Integer maxConcurrentRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulerConfiguration model) {
            queueTimeoutMinutes(model.queueTimeoutMinutes);
            maxConcurrentRuns(model.maxConcurrentRuns);
        }

        public final Integer getQueueTimeoutMinutes() {
            return queueTimeoutMinutes;
        }

        public final void setQueueTimeoutMinutes(Integer queueTimeoutMinutes) {
            this.queueTimeoutMinutes = queueTimeoutMinutes;
        }

        @Override
        public final Builder queueTimeoutMinutes(Integer queueTimeoutMinutes) {
            this.queueTimeoutMinutes = queueTimeoutMinutes;
            return this;
        }

        public final Integer getMaxConcurrentRuns() {
            return maxConcurrentRuns;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        @Override
        public SchedulerConfiguration build() {
            return new SchedulerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
