/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration;
import software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration;
import software.amazon.awssdk.services.emrserverless.model.PrometheusMonitoringConfiguration;
import software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfiguration> {
    private static final SdkField<S3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::s3MonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::s3MonitoringConfiguration)).constructor(S3MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build()}).build();
    private static final SdkField<ManagedPersistenceMonitoringConfiguration> MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedPersistenceMonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::managedPersistenceMonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::managedPersistenceMonitoringConfiguration)).constructor(ManagedPersistenceMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPersistenceMonitoringConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingConfiguration> CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLoggingConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::cloudWatchLoggingConfiguration)).setter(MonitoringConfiguration.setter(Builder::cloudWatchLoggingConfiguration)).constructor(CloudWatchLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLoggingConfiguration").build()}).build();
    private static final SdkField<PrometheusMonitoringConfiguration> PROMETHEUS_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("prometheusMonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::prometheusMonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::prometheusMonitoringConfiguration)).constructor(PrometheusMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheusMonitoringConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_MONITORING_CONFIGURATION_FIELD, MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD, PROMETHEUS_MONITORING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3MonitoringConfiguration", S3_MONITORING_CONFIGURATION_FIELD);
            this.put("managedPersistenceMonitoringConfiguration", MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD);
            this.put("cloudWatchLoggingConfiguration", CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD);
            this.put("prometheusMonitoringConfiguration", PROMETHEUS_MONITORING_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3MonitoringConfiguration s3MonitoringConfiguration;
    private final ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration;
    private final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;
    private final PrometheusMonitoringConfiguration prometheusMonitoringConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
        this.managedPersistenceMonitoringConfiguration = builder.managedPersistenceMonitoringConfiguration;
        this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
        this.prometheusMonitoringConfiguration = builder.prometheusMonitoringConfiguration;
    }

    public final S3MonitoringConfiguration s3MonitoringConfiguration() {
        return this.s3MonitoringConfiguration;
    }

    public final ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration() {
        return this.managedPersistenceMonitoringConfiguration;
    }

    public final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration() {
        return this.cloudWatchLoggingConfiguration;
    }

    public final PrometheusMonitoringConfiguration prometheusMonitoringConfiguration() {
        return this.prometheusMonitoringConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedPersistenceMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.prometheusMonitoringConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration)obj;
        return Objects.equals(this.s3MonitoringConfiguration(), other.s3MonitoringConfiguration()) && Objects.equals(this.managedPersistenceMonitoringConfiguration(), other.managedPersistenceMonitoringConfiguration()) && Objects.equals(this.cloudWatchLoggingConfiguration(), other.cloudWatchLoggingConfiguration()) && Objects.equals(this.prometheusMonitoringConfiguration(), other.prometheusMonitoringConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfiguration").add("S3MonitoringConfiguration", (Object)this.s3MonitoringConfiguration()).add("ManagedPersistenceMonitoringConfiguration", (Object)this.managedPersistenceMonitoringConfiguration()).add("CloudWatchLoggingConfiguration", (Object)this.cloudWatchLoggingConfiguration()).add("PrometheusMonitoringConfiguration", (Object)this.prometheusMonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3MonitoringConfiguration()));
            }
            case "managedPersistenceMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.managedPersistenceMonitoringConfiguration()));
            }
            case "cloudWatchLoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingConfiguration()));
            }
            case "prometheusMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.prometheusMonitoringConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3MonitoringConfiguration s3MonitoringConfiguration;
        private ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration;
        private CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;
        private PrometheusMonitoringConfiguration prometheusMonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            this.s3MonitoringConfiguration(model.s3MonitoringConfiguration);
            this.managedPersistenceMonitoringConfiguration(model.managedPersistenceMonitoringConfiguration);
            this.cloudWatchLoggingConfiguration(model.cloudWatchLoggingConfiguration);
            this.prometheusMonitoringConfiguration(model.prometheusMonitoringConfiguration);
        }

        public final S3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(S3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public final ManagedPersistenceMonitoringConfiguration.Builder getManagedPersistenceMonitoringConfiguration() {
            return this.managedPersistenceMonitoringConfiguration != null ? this.managedPersistenceMonitoringConfiguration.toBuilder() : null;
        }

        public final void setManagedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration.BuilderImpl managedPersistenceMonitoringConfiguration) {
            this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration != null ? managedPersistenceMonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration) {
            this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration;
            return this;
        }

        public final CloudWatchLoggingConfiguration.Builder getCloudWatchLoggingConfiguration() {
            return this.cloudWatchLoggingConfiguration != null ? this.cloudWatchLoggingConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration.BuilderImpl cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
            return this;
        }

        public final PrometheusMonitoringConfiguration.Builder getPrometheusMonitoringConfiguration() {
            return this.prometheusMonitoringConfiguration != null ? this.prometheusMonitoringConfiguration.toBuilder() : null;
        }

        public final void setPrometheusMonitoringConfiguration(PrometheusMonitoringConfiguration.BuilderImpl prometheusMonitoringConfiguration) {
            this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration != null ? prometheusMonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration prometheusMonitoringConfiguration) {
            this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration;
            return this;
        }

        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfiguration> {
        public Builder s3MonitoringConfiguration(S3MonitoringConfiguration var1);

        default public Builder s3MonitoringConfiguration(Consumer<S3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return this.s3MonitoringConfiguration((S3MonitoringConfiguration)((S3MonitoringConfiguration.Builder)S3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration)).build());
        }

        public Builder managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration var1);

        default public Builder managedPersistenceMonitoringConfiguration(Consumer<ManagedPersistenceMonitoringConfiguration.Builder> managedPersistenceMonitoringConfiguration) {
            return this.managedPersistenceMonitoringConfiguration((ManagedPersistenceMonitoringConfiguration)((ManagedPersistenceMonitoringConfiguration.Builder)ManagedPersistenceMonitoringConfiguration.builder().applyMutation(managedPersistenceMonitoringConfiguration)).build());
        }

        public Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration var1);

        default public Builder cloudWatchLoggingConfiguration(Consumer<CloudWatchLoggingConfiguration.Builder> cloudWatchLoggingConfiguration) {
            return this.cloudWatchLoggingConfiguration((CloudWatchLoggingConfiguration)((CloudWatchLoggingConfiguration.Builder)CloudWatchLoggingConfiguration.builder().applyMutation(cloudWatchLoggingConfiguration)).build());
        }

        public Builder prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration var1);

        default public Builder prometheusMonitoringConfiguration(Consumer<PrometheusMonitoringConfiguration.Builder> prometheusMonitoringConfiguration) {
            return this.prometheusMonitoringConfiguration((PrometheusMonitoringConfiguration)((PrometheusMonitoringConfiguration.Builder)PrometheusMonitoringConfiguration.builder().applyMutation(prometheusMonitoringConfiguration)).build());
        }
    }
}

