/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration specification to be used to override existing configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationOverrides.Builder, ConfigurationOverrides> {
    private static final SdkField<List<Configuration>> APPLICATION_CONFIGURATION_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("applicationConfiguration")
            .getter(getter(ConfigurationOverrides::applicationConfiguration))
            .setter(setter(Builder::applicationConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("monitoringConfiguration")
            .getter(getter(ConfigurationOverrides::monitoringConfiguration)).setter(setter(Builder::monitoringConfiguration))
            .constructor(MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Configuration> applicationConfiguration;

    private final MonitoringConfiguration monitoringConfiguration;

    private ConfigurationOverrides(BuilderImpl builder) {
        this.applicationConfiguration = builder.applicationConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationConfiguration() {
        return applicationConfiguration != null && !(applicationConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The override configurations for the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationConfiguration} method.
     * </p>
     * 
     * @return The override configurations for the application.
     */
    public final List<Configuration> applicationConfiguration() {
        return applicationConfiguration;
    }

    /**
     * <p>
     * The override configurations for monitoring.
     * </p>
     * 
     * @return The override configurations for monitoring.
     */
    public final MonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationConfiguration() ? applicationConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOverrides)) {
            return false;
        }
        ConfigurationOverrides other = (ConfigurationOverrides) obj;
        return hasApplicationConfiguration() == other.hasApplicationConfiguration()
                && Objects.equals(applicationConfiguration(), other.applicationConfiguration())
                && Objects.equals(monitoringConfiguration(), other.monitoringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationOverrides")
                .add("ApplicationConfiguration", hasApplicationConfiguration() ? applicationConfiguration() : null)
                .add("MonitoringConfiguration", monitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationConfiguration":
            return Optional.ofNullable(clazz.cast(applicationConfiguration()));
        case "monitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationConfiguration", APPLICATION_CONFIGURATION_FIELD);
        map.put("monitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationOverrides, T> g) {
        return obj -> g.apply((ConfigurationOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationOverrides> {
        /**
         * <p>
         * The override configurations for the application.
         * </p>
         * 
         * @param applicationConfiguration
         *        The override configurations for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfiguration(Collection<Configuration> applicationConfiguration);

        /**
         * <p>
         * The override configurations for the application.
         * </p>
         * 
         * @param applicationConfiguration
         *        The override configurations for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfiguration(Configuration... applicationConfiguration);

        /**
         * <p>
         * The override configurations for the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emrserverless.model.Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationConfiguration(List<Configuration>)}.
         * 
         * @param applicationConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emrserverless.model.Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationConfiguration(java.util.Collection<Configuration>)
         */
        Builder applicationConfiguration(Consumer<Configuration.Builder>... applicationConfiguration);

        /**
         * <p>
         * The override configurations for monitoring.
         * </p>
         * 
         * @param monitoringConfiguration
         *        The override configurations for monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * The override configurations for monitoring.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfiguration.Builder} avoiding
         * the need to create one manually via {@link MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringConfiguration(MonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(MonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(MonitoringConfiguration.builder().applyMutation(monitoringConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Configuration> applicationConfiguration = DefaultSdkAutoConstructList.getInstance();

        private MonitoringConfiguration monitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOverrides model) {
            applicationConfiguration(model.applicationConfiguration);
            monitoringConfiguration(model.monitoringConfiguration);
        }

        public final List<Configuration.Builder> getApplicationConfiguration() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.applicationConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationConfiguration(Collection<Configuration.BuilderImpl> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copyFromBuilder(applicationConfiguration);
        }

        @Override
        public final Builder applicationConfiguration(Collection<Configuration> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copy(applicationConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Configuration... applicationConfiguration) {
            applicationConfiguration(Arrays.asList(applicationConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Consumer<Configuration.Builder>... applicationConfiguration) {
            applicationConfiguration(Stream.of(applicationConfiguration)
                    .map(c -> Configuration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        @Override
        public ConfigurationOverrides build() {
            return new ConfigurationOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
