/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The driver that the job runs on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDriver implements SdkPojo, Serializable, ToCopyableBuilder<JobDriver.Builder, JobDriver> {
    private static final SdkField<SparkSubmit> SPARK_SUBMIT_FIELD = SdkField.<SparkSubmit> builder(MarshallingType.SDK_POJO)
            .memberName("sparkSubmit").getter(getter(JobDriver::sparkSubmit)).setter(setter(Builder::sparkSubmit))
            .constructor(SparkSubmit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSubmit").build()).build();

    private static final SdkField<Hive> HIVE_FIELD = SdkField.<Hive> builder(MarshallingType.SDK_POJO).memberName("hive")
            .getter(getter(JobDriver::hive)).setter(setter(Builder::hive)).constructor(Hive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SPARK_SUBMIT_FIELD, HIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SparkSubmit sparkSubmit;

    private final Hive hive;

    private final Type type;

    private JobDriver(BuilderImpl builder) {
        this.sparkSubmit = builder.sparkSubmit;
        this.hive = builder.hive;
        this.type = builder.type;
    }

    /**
     * <p>
     * The job driver parameters specified for Spark.
     * </p>
     * 
     * @return The job driver parameters specified for Spark.
     */
    public final SparkSubmit sparkSubmit() {
        return sparkSubmit;
    }

    /**
     * <p>
     * The job driver parameters specified for Hive.
     * </p>
     * 
     * @return The job driver parameters specified for Hive.
     */
    public final Hive hive() {
        return hive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sparkSubmit());
        hashCode = 31 * hashCode + Objects.hashCode(hive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDriver)) {
            return false;
        }
        JobDriver other = (JobDriver) obj;
        return Objects.equals(sparkSubmit(), other.sparkSubmit()) && Objects.equals(hive(), other.hive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDriver").add("SparkSubmit", sparkSubmit()).add("Hive", hive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sparkSubmit":
            return Optional.ofNullable(clazz.cast(sparkSubmit()));
        case "hive":
            return Optional.ofNullable(clazz.cast(hive()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #sparkSubmit()} initialized to the given value.
     *
     * <p>
     * The job driver parameters specified for Spark.
     * </p>
     * 
     * @param sparkSubmit
     *        The job driver parameters specified for Spark.
     */
    public static JobDriver fromSparkSubmit(SparkSubmit sparkSubmit) {
        return builder().sparkSubmit(sparkSubmit).build();
    }

    /**
     * Create an instance of this class with {@link #sparkSubmit()} initialized to the given value.
     *
     * <p>
     * The job driver parameters specified for Spark.
     * </p>
     * 
     * @param sparkSubmit
     *        The job driver parameters specified for Spark.
     */
    public static JobDriver fromSparkSubmit(Consumer<SparkSubmit.Builder> sparkSubmit) {
        SparkSubmit.Builder builder = SparkSubmit.builder();
        sparkSubmit.accept(builder);
        return fromSparkSubmit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #hive()} initialized to the given value.
     *
     * <p>
     * The job driver parameters specified for Hive.
     * </p>
     * 
     * @param hive
     *        The job driver parameters specified for Hive.
     */
    public static JobDriver fromHive(Hive hive) {
        return builder().hive(hive).build();
    }

    /**
     * Create an instance of this class with {@link #hive()} initialized to the given value.
     *
     * <p>
     * The job driver parameters specified for Hive.
     * </p>
     * 
     * @param hive
     *        The job driver parameters specified for Hive.
     */
    public static JobDriver fromHive(Consumer<Hive.Builder> hive) {
        Hive.Builder builder = Hive.builder();
        hive.accept(builder);
        return fromHive(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sparkSubmit", SPARK_SUBMIT_FIELD);
        map.put("hive", HIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDriver, T> g) {
        return obj -> g.apply((JobDriver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDriver> {
        /**
         * <p>
         * The job driver parameters specified for Spark.
         * </p>
         * 
         * @param sparkSubmit
         *        The job driver parameters specified for Spark.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSubmit(SparkSubmit sparkSubmit);

        /**
         * <p>
         * The job driver parameters specified for Spark.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkSubmit.Builder} avoiding the need to
         * create one manually via {@link SparkSubmit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkSubmit.Builder#build()} is called immediately and its result
         * is passed to {@link #sparkSubmit(SparkSubmit)}.
         * 
         * @param sparkSubmit
         *        a consumer that will call methods on {@link SparkSubmit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkSubmit(SparkSubmit)
         */
        default Builder sparkSubmit(Consumer<SparkSubmit.Builder> sparkSubmit) {
            return sparkSubmit(SparkSubmit.builder().applyMutation(sparkSubmit).build());
        }

        /**
         * <p>
         * The job driver parameters specified for Hive.
         * </p>
         * 
         * @param hive
         *        The job driver parameters specified for Hive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hive(Hive hive);

        /**
         * <p>
         * The job driver parameters specified for Hive.
         * </p>
         * This is a convenience method that creates an instance of the {@link Hive.Builder} avoiding the need to create
         * one manually via {@link Hive#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hive.Builder#build()} is called immediately and its result is
         * passed to {@link #hive(Hive)}.
         * 
         * @param hive
         *        a consumer that will call methods on {@link Hive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hive(Hive)
         */
        default Builder hive(Consumer<Hive.Builder> hive) {
            return hive(Hive.builder().applyMutation(hive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SparkSubmit sparkSubmit;

        private Hive hive;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobDriver model) {
            sparkSubmit(model.sparkSubmit);
            hive(model.hive);
        }

        public final SparkSubmit.Builder getSparkSubmit() {
            return sparkSubmit != null ? sparkSubmit.toBuilder() : null;
        }

        public final void setSparkSubmit(SparkSubmit.BuilderImpl sparkSubmit) {
            Object oldValue = this.sparkSubmit;
            this.sparkSubmit = sparkSubmit != null ? sparkSubmit.build() : null;
            handleUnionValueChange(Type.SPARK_SUBMIT, oldValue, this.sparkSubmit);
        }

        @Override
        public final Builder sparkSubmit(SparkSubmit sparkSubmit) {
            Object oldValue = this.sparkSubmit;
            this.sparkSubmit = sparkSubmit;
            handleUnionValueChange(Type.SPARK_SUBMIT, oldValue, this.sparkSubmit);
            return this;
        }

        public final Hive.Builder getHive() {
            return hive != null ? hive.toBuilder() : null;
        }

        public final void setHive(Hive.BuilderImpl hive) {
            Object oldValue = this.hive;
            this.hive = hive != null ? hive.build() : null;
            handleUnionValueChange(Type.HIVE, oldValue, this.hive);
        }

        @Override
        public final Builder hive(Hive hive) {
            Object oldValue = this.hive;
            this.hive = hive;
            handleUnionValueChange(Type.HIVE, oldValue, this.hive);
            return this;
        }

        @Override
        public JobDriver build() {
            return new JobDriver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobDriver#type()
     */
    public enum Type {
        SPARK_SUBMIT,

        HIVE,

        UNKNOWN_TO_SDK_VERSION
    }
}
