/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobRunAttemptsResponse extends EmrServerlessResponse implements
        ToCopyableBuilder<ListJobRunAttemptsResponse.Builder, ListJobRunAttemptsResponse> {
    private static final SdkField<List<JobRunAttemptSummary>> JOB_RUN_ATTEMPTS_FIELD = SdkField
            .<List<JobRunAttemptSummary>> builder(MarshallingType.LIST)
            .memberName("jobRunAttempts")
            .getter(getter(ListJobRunAttemptsResponse::jobRunAttempts))
            .setter(setter(Builder::jobRunAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAttempts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobRunAttemptSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobRunAttemptSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobRunAttemptsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUN_ATTEMPTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<JobRunAttemptSummary> jobRunAttempts;

    private final String nextToken;

    private ListJobRunAttemptsResponse(BuilderImpl builder) {
        super(builder);
        this.jobRunAttempts = builder.jobRunAttempts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobRunAttempts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobRunAttempts() {
        return jobRunAttempts != null && !(jobRunAttempts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of the listed job run attempt objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobRunAttempts} method.
     * </p>
     * 
     * @return The array of the listed job run attempt objects.
     */
    public final List<JobRunAttemptSummary> jobRunAttempts() {
        return jobRunAttempts;
    }

    /**
     * <p>
     * The output displays the token for the next set of application results. This is required for pagination and is
     * available as a response of the previous request.
     * </p>
     * 
     * @return The output displays the token for the next set of application results. This is required for pagination
     *         and is available as a response of the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobRunAttempts() ? jobRunAttempts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobRunAttemptsResponse)) {
            return false;
        }
        ListJobRunAttemptsResponse other = (ListJobRunAttemptsResponse) obj;
        return hasJobRunAttempts() == other.hasJobRunAttempts() && Objects.equals(jobRunAttempts(), other.jobRunAttempts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobRunAttemptsResponse")
                .add("JobRunAttempts", hasJobRunAttempts() ? jobRunAttempts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobRunAttempts":
            return Optional.ofNullable(clazz.cast(jobRunAttempts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobRunAttempts", JOB_RUN_ATTEMPTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobRunAttemptsResponse, T> g) {
        return obj -> g.apply((ListJobRunAttemptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobRunAttemptsResponse> {
        /**
         * <p>
         * The array of the listed job run attempt objects.
         * </p>
         * 
         * @param jobRunAttempts
         *        The array of the listed job run attempt objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunAttempts(Collection<JobRunAttemptSummary> jobRunAttempts);

        /**
         * <p>
         * The array of the listed job run attempt objects.
         * </p>
         * 
         * @param jobRunAttempts
         *        The array of the listed job run attempt objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunAttempts(JobRunAttemptSummary... jobRunAttempts);

        /**
         * <p>
         * The array of the listed job run attempt objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #jobRunAttempts(List<JobRunAttemptSummary>)}.
         * 
         * @param jobRunAttempts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRunAttempts(java.util.Collection<JobRunAttemptSummary>)
         */
        Builder jobRunAttempts(Consumer<JobRunAttemptSummary.Builder>... jobRunAttempts);

        /**
         * <p>
         * The output displays the token for the next set of application results. This is required for pagination and is
         * available as a response of the previous request.
         * </p>
         * 
         * @param nextToken
         *        The output displays the token for the next set of application results. This is required for pagination
         *        and is available as a response of the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EmrServerlessResponse.BuilderImpl implements Builder {
        private List<JobRunAttemptSummary> jobRunAttempts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobRunAttemptsResponse model) {
            super(model);
            jobRunAttempts(model.jobRunAttempts);
            nextToken(model.nextToken);
        }

        public final List<JobRunAttemptSummary.Builder> getJobRunAttempts() {
            List<JobRunAttemptSummary.Builder> result = JobRunAttemptsCopier.copyToBuilder(this.jobRunAttempts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobRunAttempts(Collection<JobRunAttemptSummary.BuilderImpl> jobRunAttempts) {
            this.jobRunAttempts = JobRunAttemptsCopier.copyFromBuilder(jobRunAttempts);
        }

        @Override
        public final Builder jobRunAttempts(Collection<JobRunAttemptSummary> jobRunAttempts) {
            this.jobRunAttempts = JobRunAttemptsCopier.copy(jobRunAttempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRunAttempts(JobRunAttemptSummary... jobRunAttempts) {
            jobRunAttempts(Arrays.asList(jobRunAttempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRunAttempts(Consumer<JobRunAttemptSummary.Builder>... jobRunAttempts) {
            jobRunAttempts(Stream.of(jobRunAttempts).map(c -> JobRunAttemptSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobRunAttemptsResponse build() {
            return new ListJobRunAttemptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
