/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrserverless.model.EmrServerlessRequest;
import software.amazon.awssdk.services.emrserverless.model.JobDriver;
import software.amazon.awssdk.services.emrserverless.model.JobRunMode;
import software.amazon.awssdk.services.emrserverless.model.RetryPolicy;
import software.amazon.awssdk.services.emrserverless.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartJobRunRequest
extends EmrServerlessRequest
implements ToCopyableBuilder<Builder, StartJobRunRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(StartJobRunRequest.getter(StartJobRunRequest::applicationId)).setter(StartJobRunRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartJobRunRequest.getter(StartJobRunRequest::clientToken)).setter(StartJobRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(StartJobRunRequest.getter(StartJobRunRequest::executionRoleArn)).setter(StartJobRunRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDriver").getter(StartJobRunRequest.getter(StartJobRunRequest::jobDriver)).setter(StartJobRunRequest.setter(Builder::jobDriver)).constructor(JobDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(StartJobRunRequest.getter(StartJobRunRequest::configurationOverrides)).setter(StartJobRunRequest.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartJobRunRequest.getter(StartJobRunRequest::tags)).setter(StartJobRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> EXECUTION_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionTimeoutMinutes").getter(StartJobRunRequest.getter(StartJobRunRequest::executionTimeoutMinutes)).setter(StartJobRunRequest.setter(Builder::executionTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutMinutes").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartJobRunRequest.getter(StartJobRunRequest::name)).setter(StartJobRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(StartJobRunRequest.getter(StartJobRunRequest::modeAsString)).setter(StartJobRunRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<RetryPolicy> RETRY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryPolicy").getter(StartJobRunRequest.getter(StartJobRunRequest::retryPolicy)).setter(StartJobRunRequest.setter(Builder::retryPolicy)).constructor(RetryPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, JOB_DRIVER_FIELD, CONFIGURATION_OVERRIDES_FIELD, TAGS_FIELD, EXECUTION_TIMEOUT_MINUTES_FIELD, NAME_FIELD, MODE_FIELD, RETRY_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartJobRunRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String clientToken;
    private final String executionRoleArn;
    private final JobDriver jobDriver;
    private final ConfigurationOverrides configurationOverrides;
    private final Map<String, String> tags;
    private final Long executionTimeoutMinutes;
    private final String name;
    private final String mode;
    private final RetryPolicy retryPolicy;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.jobDriver = builder.jobDriver;
        this.configurationOverrides = builder.configurationOverrides;
        this.tags = builder.tags;
        this.executionTimeoutMinutes = builder.executionTimeoutMinutes;
        this.name = builder.name;
        this.mode = builder.mode;
        this.retryPolicy = builder.retryPolicy;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final JobDriver jobDriver() {
        return this.jobDriver;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Long executionTimeoutMinutes() {
        return this.executionTimeoutMinutes;
    }

    public final String name() {
        return this.name;
    }

    public final JobRunMode mode() {
        return JobRunMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.jobDriver(), other.jobDriver()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.executionTimeoutMinutes(), other.executionTimeoutMinutes()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.retryPolicy(), other.retryPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"StartJobRunRequest").add("ApplicationId", (Object)this.applicationId()).add("ClientToken", (Object)this.clientToken()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("JobDriver", (Object)this.jobDriver()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("Tags", this.hasTags() ? this.tags() : null).add("ExecutionTimeoutMinutes", (Object)this.executionTimeoutMinutes()).add("Name", (Object)this.name()).add("Mode", (Object)this.modeAsString()).add("RetryPolicy", (Object)this.retryPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "jobDriver": {
                return Optional.ofNullable(clazz.cast(this.jobDriver()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "executionTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutMinutes()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "retryPolicy": {
                return Optional.ofNullable(clazz.cast(this.retryPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("jobDriver", JOB_DRIVER_FIELD);
        map.put("configurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("executionTimeoutMinutes", EXECUTION_TIMEOUT_MINUTES_FIELD);
        map.put("name", NAME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("retryPolicy", RETRY_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartJobRunRequest, T> g) {
        return obj -> g.apply((StartJobRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrServerlessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String clientToken;
        private String executionRoleArn;
        private JobDriver jobDriver;
        private ConfigurationOverrides configurationOverrides;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Long executionTimeoutMinutes;
        private String name;
        private String mode;
        private RetryPolicy retryPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.clientToken(model.clientToken);
            this.executionRoleArn(model.executionRoleArn);
            this.jobDriver(model.jobDriver);
            this.configurationOverrides(model.configurationOverrides);
            this.tags(model.tags);
            this.executionTimeoutMinutes(model.executionTimeoutMinutes);
            this.name(model.name);
            this.mode(model.mode);
            this.retryPolicy(model.retryPolicy);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return this.jobDriver != null ? this.jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Long getExecutionTimeoutMinutes() {
            return this.executionTimeoutMinutes;
        }

        public final void setExecutionTimeoutMinutes(Long executionTimeoutMinutes) {
            this.executionTimeoutMinutes = executionTimeoutMinutes;
        }

        @Override
        public final Builder executionTimeoutMinutes(Long executionTimeoutMinutes) {
            this.executionTimeoutMinutes = executionTimeoutMinutes;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final RetryPolicy.Builder getRetryPolicy() {
            return this.retryPolicy != null ? this.retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(RetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartJobRunRequest> {
        public Builder applicationId(String var1);

        public Builder clientToken(String var1);

        public Builder executionRoleArn(String var1);

        public Builder jobDriver(JobDriver var1);

        default public Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return this.jobDriver((JobDriver)((JobDriver.Builder)JobDriver.builder().applyMutation(jobDriver)).build());
        }

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder executionTimeoutMinutes(Long var1);

        public Builder name(String var1);

        public Builder mode(String var1);

        public Builder mode(JobRunMode var1);

        public Builder retryPolicy(RetryPolicy var1);

        default public Builder retryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy((RetryPolicy)((RetryPolicy.Builder)RetryPolicy.builder().applyMutation(retryPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

