/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations for the Spark submit job driver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkSubmit implements SdkPojo, Serializable, ToCopyableBuilder<SparkSubmit.Builder, SparkSubmit> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryPoint").getter(getter(SparkSubmit::entryPoint)).setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()).build();

    private static final SdkField<List<String>> ENTRY_POINT_ARGUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entryPointArguments")
            .getter(getter(SparkSubmit::entryPointArguments))
            .setter(setter(Builder::entryPointArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPointArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SPARK_SUBMIT_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sparkSubmitParameters").getter(getter(SparkSubmit::sparkSubmitParameters))
            .setter(setter(Builder::sparkSubmitParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSubmitParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD,
            ENTRY_POINT_ARGUMENTS_FIELD, SPARK_SUBMIT_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryPoint;

    private final List<String> entryPointArguments;

    private final String sparkSubmitParameters;

    private SparkSubmit(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.entryPointArguments = builder.entryPointArguments;
        this.sparkSubmitParameters = builder.sparkSubmitParameters;
    }

    /**
     * <p>
     * The entry point for the Spark submit job run.
     * </p>
     * 
     * @return The entry point for the Spark submit job run.
     */
    public final String entryPoint() {
        return entryPoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntryPointArguments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntryPointArguments() {
        return entryPointArguments != null && !(entryPointArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The arguments for the Spark submit job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntryPointArguments} method.
     * </p>
     * 
     * @return The arguments for the Spark submit job run.
     */
    public final List<String> entryPointArguments() {
        return entryPointArguments;
    }

    /**
     * <p>
     * The parameters for the Spark submit job run.
     * </p>
     * 
     * @return The parameters for the Spark submit job run.
     */
    public final String sparkSubmitParameters() {
        return sparkSubmitParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntryPointArguments() ? entryPointArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sparkSubmitParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSubmit)) {
            return false;
        }
        SparkSubmit other = (SparkSubmit) obj;
        return Objects.equals(entryPoint(), other.entryPoint()) && hasEntryPointArguments() == other.hasEntryPointArguments()
                && Objects.equals(entryPointArguments(), other.entryPointArguments())
                && Objects.equals(sparkSubmitParameters(), other.sparkSubmitParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SparkSubmit").add("EntryPoint", entryPoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EntryPointArguments", entryPointArguments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SparkSubmitParameters", sparkSubmitParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "entryPointArguments":
            return Optional.ofNullable(clazz.cast(entryPointArguments()));
        case "sparkSubmitParameters":
            return Optional.ofNullable(clazz.cast(sparkSubmitParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("entryPointArguments", ENTRY_POINT_ARGUMENTS_FIELD);
        map.put("sparkSubmitParameters", SPARK_SUBMIT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkSubmit, T> g) {
        return obj -> g.apply((SparkSubmit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkSubmit> {
        /**
         * <p>
         * The entry point for the Spark submit job run.
         * </p>
         * 
         * @param entryPoint
         *        The entry point for the Spark submit job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String entryPoint);

        /**
         * <p>
         * The arguments for the Spark submit job run.
         * </p>
         * 
         * @param entryPointArguments
         *        The arguments for the Spark submit job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPointArguments(Collection<String> entryPointArguments);

        /**
         * <p>
         * The arguments for the Spark submit job run.
         * </p>
         * 
         * @param entryPointArguments
         *        The arguments for the Spark submit job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPointArguments(String... entryPointArguments);

        /**
         * <p>
         * The parameters for the Spark submit job run.
         * </p>
         * 
         * @param sparkSubmitParameters
         *        The parameters for the Spark submit job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkSubmitParameters(String sparkSubmitParameters);
    }

    static final class BuilderImpl implements Builder {
        private String entryPoint;

        private List<String> entryPointArguments = DefaultSdkAutoConstructList.getInstance();

        private String sparkSubmitParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSubmit model) {
            entryPoint(model.entryPoint);
            entryPointArguments(model.entryPointArguments);
            sparkSubmitParameters(model.sparkSubmitParameters);
        }

        public final String getEntryPoint() {
            return entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final Collection<String> getEntryPointArguments() {
            if (entryPointArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return entryPointArguments;
        }

        public final void setEntryPointArguments(Collection<String> entryPointArguments) {
            this.entryPointArguments = EntryPointArgumentsCopier.copy(entryPointArguments);
        }

        @Override
        public final Builder entryPointArguments(Collection<String> entryPointArguments) {
            this.entryPointArguments = EntryPointArgumentsCopier.copy(entryPointArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPointArguments(String... entryPointArguments) {
            entryPointArguments(Arrays.asList(entryPointArguments));
            return this;
        }

        public final String getSparkSubmitParameters() {
            return sparkSubmitParameters;
        }

        public final void setSparkSubmitParameters(String sparkSubmitParameters) {
            this.sparkSubmitParameters = sparkSubmitParameters;
        }

        @Override
        public final Builder sparkSubmitParameters(String sparkSubmitParameters) {
            this.sparkSubmitParameters = sparkSubmitParameters;
            return this;
        }

        @Override
        public SparkSubmit build() {
            return new SparkSubmit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
