/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrserverless.model.EntryPointArgumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparkSubmit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparkSubmit> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryPoint").getter(SparkSubmit.getter(SparkSubmit::entryPoint)).setter(SparkSubmit.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()}).build();
    private static final SdkField<List<String>> ENTRY_POINT_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entryPointArguments").getter(SparkSubmit.getter(SparkSubmit::entryPointArguments)).setter(SparkSubmit.setter(Builder::entryPointArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPointArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SPARK_SUBMIT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sparkSubmitParameters").getter(SparkSubmit.getter(SparkSubmit::sparkSubmitParameters)).setter(SparkSubmit.setter(Builder::sparkSubmitParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSubmitParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD, ENTRY_POINT_ARGUMENTS_FIELD, SPARK_SUBMIT_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparkSubmit.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryPoint;
    private final List<String> entryPointArguments;
    private final String sparkSubmitParameters;

    private SparkSubmit(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.entryPointArguments = builder.entryPointArguments;
        this.sparkSubmitParameters = builder.sparkSubmitParameters;
    }

    public final String entryPoint() {
        return this.entryPoint;
    }

    public final boolean hasEntryPointArguments() {
        return this.entryPointArguments != null && !(this.entryPointArguments instanceof SdkAutoConstructList);
    }

    public final List<String> entryPointArguments() {
        return this.entryPointArguments;
    }

    public final String sparkSubmitParameters() {
        return this.sparkSubmitParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryPointArguments() ? this.entryPointArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkSubmitParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSubmit)) {
            return false;
        }
        SparkSubmit other = (SparkSubmit)obj;
        return Objects.equals(this.entryPoint(), other.entryPoint()) && this.hasEntryPointArguments() == other.hasEntryPointArguments() && Objects.equals(this.entryPointArguments(), other.entryPointArguments()) && Objects.equals(this.sparkSubmitParameters(), other.sparkSubmitParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SparkSubmit").add("EntryPoint", (Object)(this.entryPoint() == null ? null : "*** Sensitive Data Redacted ***")).add("EntryPointArguments", (Object)(this.entryPointArguments() == null ? null : "*** Sensitive Data Redacted ***")).add("SparkSubmitParameters", (Object)(this.sparkSubmitParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "entryPointArguments": {
                return Optional.ofNullable(clazz.cast(this.entryPointArguments()));
            }
            case "sparkSubmitParameters": {
                return Optional.ofNullable(clazz.cast(this.sparkSubmitParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("entryPointArguments", ENTRY_POINT_ARGUMENTS_FIELD);
        map.put("sparkSubmitParameters", SPARK_SUBMIT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkSubmit, T> g) {
        return obj -> g.apply((SparkSubmit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryPoint;
        private List<String> entryPointArguments = DefaultSdkAutoConstructList.getInstance();
        private String sparkSubmitParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSubmit model) {
            this.entryPoint(model.entryPoint);
            this.entryPointArguments(model.entryPointArguments);
            this.sparkSubmitParameters(model.sparkSubmitParameters);
        }

        public final String getEntryPoint() {
            return this.entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final Collection<String> getEntryPointArguments() {
            if (this.entryPointArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryPointArguments;
        }

        public final void setEntryPointArguments(Collection<String> entryPointArguments) {
            this.entryPointArguments = EntryPointArgumentsCopier.copy(entryPointArguments);
        }

        @Override
        public final Builder entryPointArguments(Collection<String> entryPointArguments) {
            this.entryPointArguments = EntryPointArgumentsCopier.copy(entryPointArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPointArguments(String ... entryPointArguments) {
            this.entryPointArguments(Arrays.asList(entryPointArguments));
            return this;
        }

        public final String getSparkSubmitParameters() {
            return this.sparkSubmitParameters;
        }

        public final void setSparkSubmitParameters(String sparkSubmitParameters) {
            this.sparkSubmitParameters = sparkSubmitParameters;
        }

        @Override
        public final Builder sparkSubmitParameters(String sparkSubmitParameters) {
            this.sparkSubmitParameters = sparkSubmitParameters;
            return this;
        }

        public SparkSubmit build() {
            return new SparkSubmit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparkSubmit> {
        public Builder entryPoint(String var1);

        public Builder entryPointArguments(Collection<String> var1);

        public Builder entryPointArguments(String ... var1);

        public Builder sparkSubmitParameters(String var1);
    }
}

