/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IAM Identity Center Configuration accepts the Identity Center instance parameter required to enable trusted
 * identity propagation. This configuration allows identity propagation between integrated services and the Identity
 * Center instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityCenterConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityCenterConfigurationInput.Builder, IdentityCenterConfigurationInput> {
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityCenterInstanceArn").getter(getter(IdentityCenterConfigurationInput::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build())
            .build();

    private static final SdkField<Boolean> USER_BACKGROUND_SESSIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("userBackgroundSessionsEnabled")
            .getter(getter(IdentityCenterConfigurationInput::userBackgroundSessionsEnabled))
            .setter(setter(Builder::userBackgroundSessionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userBackgroundSessionsEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_CENTER_INSTANCE_ARN_FIELD, USER_BACKGROUND_SESSIONS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identityCenterInstanceArn;

    private final Boolean userBackgroundSessionsEnabled;

    private IdentityCenterConfigurationInput(BuilderImpl builder) {
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.userBackgroundSessionsEnabled = builder.userBackgroundSessionsEnabled;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    /**
     * <p>
     * Enables user background sessions for this application so Livy sessions can continue running after users log out
     * of their interactive notebook or their Identity Center sessions expire.
     * </p>
     * 
     * @return Enables user background sessions for this application so Livy sessions can continue running after users
     *         log out of their interactive notebook or their Identity Center sessions expire.
     */
    public final Boolean userBackgroundSessionsEnabled() {
        return userBackgroundSessionsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(userBackgroundSessionsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterConfigurationInput)) {
            return false;
        }
        IdentityCenterConfigurationInput other = (IdentityCenterConfigurationInput) obj;
        return Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn())
                && Objects.equals(userBackgroundSessionsEnabled(), other.userBackgroundSessionsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityCenterConfigurationInput").add("IdentityCenterInstanceArn", identityCenterInstanceArn())
                .add("UserBackgroundSessionsEnabled", userBackgroundSessionsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        case "userBackgroundSessionsEnabled":
            return Optional.ofNullable(clazz.cast(userBackgroundSessionsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("userBackgroundSessionsEnabled", USER_BACKGROUND_SESSIONS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterConfigurationInput, T> g) {
        return obj -> g.apply((IdentityCenterConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityCenterConfigurationInput> {
        /**
         * <p>
         * The ARN of the IAM Identity Center instance.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The ARN of the IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);

        /**
         * <p>
         * Enables user background sessions for this application so Livy sessions can continue running after users log
         * out of their interactive notebook or their Identity Center sessions expire.
         * </p>
         * 
         * @param userBackgroundSessionsEnabled
         *        Enables user background sessions for this application so Livy sessions can continue running after
         *        users log out of their interactive notebook or their Identity Center sessions expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBackgroundSessionsEnabled(Boolean userBackgroundSessionsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String identityCenterInstanceArn;

        private Boolean userBackgroundSessionsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterConfigurationInput model) {
            identityCenterInstanceArn(model.identityCenterInstanceArn);
            userBackgroundSessionsEnabled(model.userBackgroundSessionsEnabled);
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final Boolean getUserBackgroundSessionsEnabled() {
            return userBackgroundSessionsEnabled;
        }

        public final void setUserBackgroundSessionsEnabled(Boolean userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
        }

        @Override
        public final Builder userBackgroundSessionsEnabled(Boolean userBackgroundSessionsEnabled) {
            this.userBackgroundSessionsEnabled = userBackgroundSessionsEnabled;
            return this;
        }

        @Override
        public IdentityCenterConfigurationInput build() {
            return new IdentityCenterConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
